/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Enumerated_Value
extends Value
implements IReferencingElement {
    private final Identifier value;

    public Enumerated_Value(Identifier value) {
        this.value = value;
    }

    protected Enumerated_Value(Undefined_LowerIdentifier_Value original) {
        this.copyGeneralProperties(original);
        this.value = original.getIdentifier();
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.ENUMERATED_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        return this.value.getName();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_TTCN3_ENUMERATED;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public Identifier getValue() {
        return this.value;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.ENUMERATED_VALUE.equals((Object)last.getValuetype()) && this.value.equals(((Enumerated_Value)last).getValue());
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.value.getLocation());
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null || this.myGovernor == null) {
            return;
        }
        if (referenceFinder.assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE && referenceFinder.type == this.myGovernor && this.value.equals(referenceFinder.fieldId)) {
            foundIdentifiers.add(new ReferenceFinder.Hit(this.value));
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }

    @Override
    public Declaration getDeclaration() {
        IType type = this.getMyGovernor();
        if (type == null) {
            return null;
        }
        if ((type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) instanceof ITypeWithComponents) {
            Identifier resultId = ((ITypeWithComponents)((Object)type)).getComponentIdentifierByName(this.value);
            return Declaration.createInstance(type.getDefiningAssignment(), resultId);
        }
        return null;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(MessageFormat.format("{0}.operator_assign({1}.enum_type.{2});\n", name, this.getMyGovernor().getGenNameValue(aData, source), this.getValue().getName()));
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        StringBuilder source = new StringBuilder();
        source.append(MessageFormat.format("{0}.enum_type.{1}", this.getMyGovernor().getGenNameValue(aData, source), this.getValue().getName()));
        return source;
    }
}

