/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;

public class ASTLocationConsistencyVisitor
extends ASTVisitor {
    IDocument document;
    boolean isTtcn;

    public ASTLocationConsistencyVisitor(IDocument document, boolean isTtcn) {
        this.document = document;
        this.isTtcn = isTtcn;
    }

    @Override
    public int visit(IVisitableNode node) {
        if (node instanceof Identifier) {
            String name;
            Identifier id = (Identifier)node;
            String string = name = this.isTtcn ? id.getTtcnName() : id.getAsnName();
            if (this.isTtcn && "anytype".equals(name)) {
                return 3;
            }
            Location loc = id.getLocation();
            int offset = loc.getOffset();
            int length = loc.getEndOffset() - loc.getOffset();
            try {
                String strAtLoc = this.document.get(offset, length);
                if (!strAtLoc.equals(name)) {
                    TITANDebugConsole.println("AST<->document inconsistency: id=[" + name + "] at offset,length=" + offset + "," + length + " doc.content=[" + strAtLoc + "]");
                }
            }
            catch (BadLocationException e) {
                TITANDebugConsole.println("AST<->document inconsistency: id=[" + name + "] at offset,length=" + offset + "," + length + " BadLocationException: " + e.getMessage());
            }
        }
        return 3;
    }
}

