/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.maincontroller;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocator;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.core.TITANJavaBuilder;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.executor.designerconnection.DynamicLinkingHelper;
import org.eclipse.titan.executor.designerconnection.EnvironmentHelper;
import org.eclipse.titan.executor.executors.LaunchConfigurationUtil;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NativeJavaMainControllerTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY = "";
    private static final String NAME = "Basic Main Controller options";
    private static final String PROJECT = "Project (REQUIRED):";
    private static final String PROJECT_TOOLTIP = "This field is required.\nWhen an existing project is selected and the Designer plug-in is also present the working directory and executable fields are filled out automatically\n  with the values set as project properties.";
    private static final String CONFIGFILE = "  Configuration file:";
    private static final String CONFIGFILE_REQUIRED = "Configuration file (REQUIRED):";
    private static final String CONFIGFILE_TOOLTIP = "This field is required.\nThe runtime configuration file used to describe the runtime behaviour of the executable test program.";
    private static final String BROWSE_WORKSPACE = "Browse Workspace..";
    public static final String BUILDER_ID = "org.eclipse.titan.designer.core.TITANJavaBuilder";
    private final BasicProjectSelectorListener generalListener;
    private final ILaunchConfigurationTabGroup tabGroup;
    private ILaunchConfigurationWorkingCopy lastConfiguration;
    protected Text projectNameText;
    protected TITANResourceLocator configurationFileText;
    private Group configFileGroup;
    private Button projectSelectionButton;
    private Button automaticExecuteSectionExecution;
    private Button singleModeExecutionCheckBox;
    protected boolean projectIsValid;
    private boolean projectIsJava;
    protected boolean configurationFileIsValid;
    protected List<Throwable> exceptions = new ArrayList<Throwable>();

    public NativeJavaMainControllerTab(ILaunchConfigurationTabGroup tabGroup) {
        this.tabGroup = tabGroup;
        this.generalListener = new BasicProjectSelectorListener();
        this.projectIsValid = true;
        this.projectIsJava = true;
        this.configurationFileIsValid = false;
    }

    protected void addListeners() {
        this.projectNameText.addModifyListener((ModifyListener)this.generalListener);
        this.projectSelectionButton.addSelectionListener((SelectionListener)this.generalListener);
        this.configurationFileText.getTextControl((Composite)this.configFileGroup).addModifyListener((ModifyListener)this.generalListener);
        this.automaticExecuteSectionExecution.addSelectionListener((SelectionListener)this.generalListener);
        this.singleModeExecutionCheckBox.addSelectionListener((SelectionListener)this.generalListener);
    }

    public final void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        pageComposite.setLayoutData((Object)pageCompositeGridData);
        this.createProjectEditor(pageComposite);
        this.createConfigurationEditor(pageComposite);
        this.setControl((Control)pageComposite);
    }

    public final String getName() {
        return NAME;
    }

    public final Image getImage() {
        return ImageCache.getImage("titan.gif");
    }

    public final void initializeFrom(ILaunchConfiguration configuration) {
        try {
            IProject project;
            boolean tempBoolean;
            this.lastConfiguration = configuration.getWorkingCopy();
            String temp = configuration.getAttribute("org.eclipse.titan.executor.projectName", EMPTY);
            if (!temp.equals(this.projectNameText.getText())) {
                this.projectNameText.setText(temp);
            }
            this.addListeners();
            temp = configuration.getAttribute("org.eclipse.titan.executor.configurationFilePath", EMPTY);
            if (!temp.equals(this.configurationFileText.getStringValue())) {
                this.configurationFileText.setStringValue(temp);
            }
            if ((tempBoolean = configuration.getAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", false)) != this.automaticExecuteSectionExecution.getSelection()) {
                this.automaticExecuteSectionExecution.setSelection(tempBoolean);
            }
            if ((tempBoolean = configuration.getAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", false)) != this.singleModeExecutionCheckBox.getSelection()) {
                this.singleModeExecutionCheckBox.setSelection(tempBoolean);
            }
            if ((project = this.getProject()) == null) {
                return;
            }
            String projectPath = project.getLocation().toOSString();
            this.configurationFileText.setRootPath(projectPath);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.projectName", this.projectNameText.getText());
        String configFileName = this.configurationFileText.getStringValue();
        configuration.setAttribute("org.eclipse.titan.executor.configurationFilePath", configFileName);
        configuration.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", this.automaticExecuteSectionExecution.getSelection());
        boolean singleMode = this.singleModeExecutionCheckBox.getSelection();
        configuration.setAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", singleMode);
        IProject project = this.getProject();
        IFile configFile = null;
        if (project != null) {
            configFile = project.getFile(configFileName);
        }
        configuration.setMappedResources(new IResource[]{project, configFile});
        ArrayList<String> list = new ArrayList<String>(2);
        try {
            if (singleMode) {
                ILaunchConfiguration confSingle = LaunchConfigurationUtil.createJavaAppLaunchConfiguration((ILaunchConfiguration)configuration);
                if (confSingle == null) {
                    return;
                }
                LaunchConfigurationUtil.disableHCinGroupLaunchConfiguration(configuration);
                list.add(confSingle.getName());
                LaunchConfigurationUtil.setLinkedLaunchConfigurations(configuration, list);
                return;
            }
            ILaunchConfiguration confHC = LaunchConfigurationUtil.createJavaAppLaunchConfiguration((ILaunchConfiguration)configuration);
            ILaunchConfiguration confGroup = LaunchConfigurationUtil.createGroupLaunchConfiguration((ILaunchConfiguration)configuration, confHC);
            if (confHC == null || confGroup == null) {
                return;
            }
            list.add(confHC.getName());
            list.add(confGroup.getName());
            LaunchConfigurationUtil.setLinkedLaunchConfigurations(configuration, list);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.projectName", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.workingdirectoryPath", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.executableFilePath", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.configurationFilePath", EMPTY);
        configuration.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", false);
        configuration.setAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", false);
        configuration.setMappedResources(new IResource[0]);
    }

    protected final void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(PROJECT);
        group.setToolTipText(PROJECT_TOOLTIP);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectNameText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.projectNameText.setLayoutData((Object)gd);
        this.projectNameText.setFont(font);
        this.projectSelectionButton = this.createPushButton((Composite)group, BROWSE_WORKSPACE, null);
    }

    protected final void createConfigurationEditor(Composite parent) {
        Font font = parent.getFont();
        this.configFileGroup = new Group(parent, 0);
        this.configFileGroup.setText(CONFIGFILE_REQUIRED);
        this.configFileGroup.setToolTipText(CONFIGFILE_TOOLTIP);
        GridData gd = new GridData(768);
        this.configFileGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.configFileGroup.setLayout((Layout)layout);
        this.configFileGroup.setFont(font);
        IProject project = this.getProject();
        this.configurationFileText = project == null ? new TITANResourceLocator(CONFIGFILE, (Composite)this.configFileGroup, 1, EMPTY) : new TITANResourceLocator(CONFIGFILE, (Composite)this.configFileGroup, 1, this.getProject().getLocation().toOSString());
        this.configurationFileText.getLabelControl((Composite)this.configFileGroup).setToolTipText(CONFIGFILE_TOOLTIP);
        String[] extensions = new String[]{"*.cfg", "*.*"};
        this.configurationFileText.setFilterExtensions(extensions);
        this.automaticExecuteSectionExecution = new Button((Composite)this.configFileGroup, 32);
        this.automaticExecuteSectionExecution.setText("Execute automatically");
        this.automaticExecuteSectionExecution.setToolTipText("Execute the `EXECUTE' section of the configuration file automatically when launched");
        this.automaticExecuteSectionExecution.setSelection(false);
        this.automaticExecuteSectionExecution.setEnabled(true);
        this.singleModeExecutionCheckBox = new Button((Composite)this.configFileGroup, 32);
        this.singleModeExecutionCheckBox.setText("Execute in single mode");
        this.singleModeExecutionCheckBox.setToolTipText("Executes the Titan Java project in single mode");
        this.singleModeExecutionCheckBox.setSelection(false);
        this.singleModeExecutionCheckBox.setEnabled(true);
    }

    protected final void handleProjectButtonSelected() {
        String projectName;
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project selection");
        dialog.setMessage("Assign a project to the run configuration");
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> availableProjects = new ArrayList<IProject>(projects.length);
        for (IProject project : projects) {
            try {
                if (!project.isAccessible() || !project.hasNature("org.eclipse.titan.designer.core.TITANNature") || !TITANJavaBuilder.isBuilderEnabled((IProject)project)) continue;
                availableProjects.add(project);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        if (availableProjects.isEmpty()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while searching for projects in the workspace", (String)"No proper project was found in the workspace for this run configuration type");
            return;
        }
        dialog.setElements((Object[])availableProjects.toArray(new IProject[availableProjects.size()]));
        if (dialog.open() == 0 && !(projectName = ((IProject)dialog.getFirstResult()).getName()).equals(this.projectNameText.getText())) {
            this.projectNameText.setText(projectName);
        }
    }

    public final IProject getProject() {
        if (this.projectNameText == null) {
            return null;
        }
        String projectName = this.projectNameText.getText();
        IProject projectWithTitanNature = DynamicLinkingHelper.getProject(projectName);
        if (projectWithTitanNature != null) {
            this.projectIsValid = true;
        }
        return projectWithTitanNature;
    }

    private void handleProjectNameModified() {
        IProject project = this.getProject();
        if (project == null) {
            this.projectIsValid = false;
            return;
        }
        this.projectIsValid = true;
        String projectPath = project.getLocation().toOSString();
        this.configurationFileText.setRootPath(projectPath);
        List cfgFiles = ProjectFileHandler.getCfgFiles((IProject)project);
        if (cfgFiles.size() == 1) {
            this.configurationFileText.setStringValue(((IFile)cfgFiles.get(0)).getProjectRelativePath().toOSString());
        } else if (cfgFiles.size() > 1) {
            IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
            dialog.setTitle("Config File Selection");
            dialog.setMessage("Select existing cfg file:");
            dialog.setElements((Object[])cfgFiles.toArray(new IFile[cfgFiles.size()]));
            if (dialog.open() == 0) {
                this.configurationFileText.setStringValue(((IFile)dialog.getFirstResult()).getProjectRelativePath().toOSString());
            }
        }
        this.checkJavaBuilder(project);
    }

    private boolean checkJavaBuilder(IProject project) {
        IProjectDescription description;
        this.projectIsJava = false;
        if (!project.isAccessible()) {
            return false;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            return false;
        }
        ICommand[] cmds = description.getBuildSpec();
        for (int i = 0; i < cmds.length; ++i) {
            if (!BUILDER_ID.equals(cmds[i].getBuilderName())) continue;
            this.projectIsJava = true;
            return true;
        }
        return false;
    }

    protected final void handleConfigurationModified() {
        if (EMPTY.equals(this.configurationFileText.getStringValue())) {
            this.automaticExecuteSectionExecution.setEnabled(false);
            this.singleModeExecutionCheckBox.setEnabled(false);
            return;
        }
        IProject project = this.getProject();
        URI uri = project == null ? URIUtil.toURI((String)this.configurationFileText.getStringValue()) : TITANPathUtilities.resolvePathURI((String)this.configurationFileText.getStringValue(), (String)this.getProject().getLocation().toOSString());
        File file = new File(uri);
        if (file.exists() && file.isFile()) {
            this.exceptions.clear();
            ConfigFileHandler configHandler = new ConfigFileHandler();
            configHandler.readFromFile(file.getPath());
            if (configHandler.parseExceptions().isEmpty()) {
                HashMap<String, String> env = new HashMap<String, String>(System.getenv());
                try {
                    Map tempEnvironmentalVariables = this.lastConfiguration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
                    EnvironmentHelper.resolveVariables(env, tempEnvironmentalVariables);
                    configHandler.setEnvMap(env);
                    configHandler.processASTs();
                }
                catch (CoreException e) {
                    this.exceptions.add(e);
                    this.configurationFileIsValid = false;
                }
            }
            this.exceptions.addAll(configHandler.parseExceptions());
            if (this.exceptions.isEmpty()) {
                this.configurationFileIsValid = true;
                this.automaticExecuteSectionExecution.setEnabled(true);
                this.singleModeExecutionCheckBox.setEnabled(true);
                return;
            }
        }
        this.configurationFileIsValid = false;
        this.exceptions.clear();
        this.exceptions.add(new Exception("The path `" + URIUtil.toPath((URI)uri) + "' does not seem to be correct."));
        this.automaticExecuteSectionExecution.setEnabled(false);
        this.singleModeExecutionCheckBox.setEnabled(false);
    }

    public static String getRAWWorkingDirectoryForProject(IProject project) {
        try {
            String workingDirectory = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
            return workingDirectory;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return "bin";
        }
    }

    public static String getExecutableForProject(IProject project) {
        try {
            String executable = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            if (executable != null) {
                return executable;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return EMPTY;
    }

    public boolean canSave() {
        if (!EMPTY.equals(this.projectNameText.getText()) && !this.projectIsValid) {
            return false;
        }
        if (!this.projectIsJava) {
            return false;
        }
        return super.canSave();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!EMPTY.equals(this.projectNameText.getText()) && !this.projectIsValid) {
            this.setErrorMessage("The name of the project is not valid.");
            return false;
        }
        if (!this.projectIsJava) {
            this.setErrorMessage("The project must be a Titan Java project.");
            return false;
        }
        if (EMPTY.equals(this.configurationFileText.getStringValue())) {
            this.setErrorMessage("The configuration file must be set.");
            return false;
        }
        if (!this.configurationFileIsValid) {
            if (null != this.exceptions && !this.exceptions.isEmpty()) {
                this.setErrorMessage("Problem in config file: " + this.exceptions.get(0).getMessage());
            } else {
                this.setErrorMessage("The configuration file is not valid.");
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public static boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, IProject project, String configFilePath) {
        configuration.setAttribute("org.eclipse.titan.executor.projectName", project.getName());
        configuration.setAttribute("org.eclipse.titan.executor.configurationFilePath", configFilePath);
        configuration.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", !EMPTY.equals(configFilePath));
        return true;
    }

    private final class BasicProjectSelectorListener
    extends SelectionAdapter
    implements ModifyListener {
        private BasicProjectSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (null == source) {
                return;
            }
            if (source.equals(NativeJavaMainControllerTab.this.projectNameText)) {
                NativeJavaMainControllerTab.this.handleProjectNameModified();
            } else if (source.equals(NativeJavaMainControllerTab.this.configurationFileText.getTextControl((Composite)NativeJavaMainControllerTab.this.configFileGroup))) {
                NativeJavaMainControllerTab.this.handleConfigurationModified();
            }
            NativeJavaMainControllerTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (null == source) {
                return;
            }
            if (source.equals(NativeJavaMainControllerTab.this.projectSelectionButton)) {
                NativeJavaMainControllerTab.this.handleProjectButtonSelected();
            }
            NativeJavaMainControllerTab.this.updateLaunchConfigurationDialog();
        }
    }
}

