/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor;

import java.io.IOException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class TITANDebugConsole {
    private static final String TITLE = "TITAN RUNTIME Debug console";
    private static MessageConsole console = null;
    private static boolean inHeadLessMode = !PlatformUI.isWorkbenchRunning();

    private TITANDebugConsole() {
    }

    public static synchronized MessageConsole getConsole() {
        if (null == console) {
            console = new MessageConsole(TITLE, null);
            console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
        return console;
    }

    public static void println(String message, MessageConsoleStream stream) {
        if (inHeadLessMode) {
            return;
        }
        stream.println(message);
        try {
            stream.flush();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    public static void println(String message) {
        if (inHeadLessMode) {
            return;
        }
        TITANDebugConsole.println(message, TITANDebugConsole.getConsole().newMessageStream());
    }

    public static void print(String message, MessageConsoleStream stream) {
        if (inHeadLessMode) {
            return;
        }
        stream.print(message);
    }

    public static void print(String message) {
        if (inHeadLessMode) {
            return;
        }
        TITANDebugConsole.print(message, TITANDebugConsole.getConsole().newMessageStream());
    }

    public static void println(StringBuilder message) {
        if (inHeadLessMode) {
            return;
        }
        TITANDebugConsole.println(message.toString(), TITANDebugConsole.getConsole().newMessageStream());
    }
}

