/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.core.internal.analysis.filter.AnnotationGeneratedFilter;
import org.jacoco.core.internal.analysis.filter.AssertFilter;
import org.jacoco.core.internal.analysis.filter.BridgeFilter;
import org.jacoco.core.internal.analysis.filter.EnumEmptyConstructorFilter;
import org.jacoco.core.internal.analysis.filter.EnumFilter;
import org.jacoco.core.internal.analysis.filter.ExhaustiveSwitchFilter;
import org.jacoco.core.internal.analysis.filter.FilterSet;
import org.jacoco.core.internal.analysis.filter.FinallyFilter;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.KotlinComposeFilter;
import org.jacoco.core.internal.analysis.filter.KotlinCoroutineFilter;
import org.jacoco.core.internal.analysis.filter.KotlinDefaultArgumentsFilter;
import org.jacoco.core.internal.analysis.filter.KotlinDefaultMethodsFilter;
import org.jacoco.core.internal.analysis.filter.KotlinEnumFilter;
import org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import org.jacoco.core.internal.analysis.filter.KotlinInlineClassFilter;
import org.jacoco.core.internal.analysis.filter.KotlinInlineFilter;
import org.jacoco.core.internal.analysis.filter.KotlinJvmOverloadsFilter;
import org.jacoco.core.internal.analysis.filter.KotlinLateinitFilter;
import org.jacoco.core.internal.analysis.filter.KotlinNotNullOperatorFilter;
import org.jacoco.core.internal.analysis.filter.KotlinSafeCallOperatorFilter;
import org.jacoco.core.internal.analysis.filter.KotlinSyntheticAccessorsFilter;
import org.jacoco.core.internal.analysis.filter.KotlinUnsafeCastOperatorFilter;
import org.jacoco.core.internal.analysis.filter.KotlinWhenFilter;
import org.jacoco.core.internal.analysis.filter.KotlinWhenStringFilter;
import org.jacoco.core.internal.analysis.filter.PrivateEmptyNoArgConstructorFilter;
import org.jacoco.core.internal.analysis.filter.RecordPatternFilter;
import org.jacoco.core.internal.analysis.filter.RecordsFilter;
import org.jacoco.core.internal.analysis.filter.StringSwitchFilter;
import org.jacoco.core.internal.analysis.filter.StringSwitchJavacFilter;
import org.jacoco.core.internal.analysis.filter.SynchronizedFilter;
import org.jacoco.core.internal.analysis.filter.SyntheticFilter;
import org.jacoco.core.internal.analysis.filter.TryWithResourcesEcjFilter;
import org.jacoco.core.internal.analysis.filter.TryWithResourcesJavac11Filter;
import org.jacoco.core.internal.analysis.filter.TryWithResourcesJavacFilter;
import org.objectweb.asm.tree.MethodNode;

public final class Filters {
    public static final IFilter NONE = new FilterSet(new IFilter[0]);

    private Filters() {
    }

    public static IFilter all() {
        final IFilter allCommonFilters = Filters.allCommonFilters();
        final IFilter allKotlinFilters = Filters.allKotlinFilters();
        final IFilter allNonKotlinFilters = Filters.allNonKotlinFilters();
        return new IFilter(){

            public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
                allCommonFilters.filter(methodNode, context, output);
                if (Filters.isKotlinClass(context)) {
                    allKotlinFilters.filter(methodNode, context, output);
                } else {
                    allNonKotlinFilters.filter(methodNode, context, output);
                }
            }
        };
    }

    private static IFilter allCommonFilters() {
        return new FilterSet(new EnumFilter(), new BridgeFilter(), new SynchronizedFilter(), new TryWithResourcesJavac11Filter(), new TryWithResourcesJavacFilter(), new TryWithResourcesEcjFilter(), new FinallyFilter(), new PrivateEmptyNoArgConstructorFilter(), new AssertFilter(), new StringSwitchJavacFilter(), new StringSwitchFilter(), new EnumEmptyConstructorFilter(), new RecordsFilter(), new ExhaustiveSwitchFilter(), new RecordPatternFilter(), new AnnotationGeneratedFilter());
    }

    private static IFilter allNonKotlinFilters() {
        return new FilterSet(new SyntheticFilter());
    }

    private static IFilter allKotlinFilters() {
        return new FilterSet(new KotlinGeneratedFilter(), new KotlinSyntheticAccessorsFilter(), new KotlinEnumFilter(), new KotlinJvmOverloadsFilter(), new KotlinSafeCallOperatorFilter(), new KotlinLateinitFilter(), new KotlinWhenFilter(), new KotlinWhenStringFilter(), new KotlinUnsafeCastOperatorFilter(), new KotlinNotNullOperatorFilter(), new KotlinInlineClassFilter(), new KotlinDefaultArgumentsFilter(), new KotlinInlineFilter(), new KotlinCoroutineFilter(), new KotlinDefaultMethodsFilter(), new KotlinComposeFilter());
    }

    public static boolean isKotlinClass(IFilterContext context) {
        return context.getClassAnnotations().contains("Lkotlin/Metadata;");
    }
}

