/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.util.ResourcesUtility;

public class JavaProjectUtilities {
    private JavaProjectUtilities() {
    }

    public static void createJavaProject(IProject project) throws CoreException {
        if (!project.exists()) {
            ResourcesUtility.createProject(project, null, (IProgressMonitor)new NullProgressMonitor());
            JavaProjectUtilities.addJavaNature(project, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void createPackageFragmentRoot(IPackageFragmentRoot root) throws CoreException {
        IFolder folder;
        IJavaProject project = root.getJavaProject();
        if (!project.exists()) {
            JavaProjectUtilities.createJavaProject(project.getProject());
        }
        if (!(folder = project.getProject().getFolder(root.getElementName())).exists()) {
            ResourcesUtility.createFolder(folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        List<IClasspathEntry> list = Arrays.asList(project.getRawClasspath());
        list.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
        project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public static IJavaElement resolveEnclosingElement(IJavaElement input, int offset, int length) throws JavaModelException {
        IJavaElement atOffset = null;
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaModelUtil.reconcile(cunit);
            atOffset = cunit.getElementAt(offset);
        } else if (input instanceof IClassFile) {
            IClassFile cfile = (IClassFile)input;
            atOffset = cfile.getElementAt(offset);
        } else {
            return null;
        }
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = offset + length;
        IJavaElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }
}

