"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["theia-extensions_updater_lib_electron-browser_theia-updater-frontend-module_js"],{

/***/ "../../theia-extensions/updater/lib/common/updater/theia-updater.js":
/*!**************************************************************************!*\
  !*** ../../theia-extensions/updater/lib/common/updater/theia-updater.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2020 TypeFox, EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TheiaUpdaterClient = exports.TheiaUpdater = exports.TheiaUpdaterPath = void 0;
exports.TheiaUpdaterPath = '/services/theia-updater';
exports.TheiaUpdater = Symbol('TheiaUpdater');
exports.TheiaUpdaterClient = Symbol('TheiaUpdaterClient');


/***/ }),

/***/ "../../theia-extensions/updater/lib/electron-browser/theia-updater-frontend-module.js":
/*!********************************************************************************************!*\
  !*** ../../theia-extensions/updater/lib/electron-browser/theia-updater-frontend-module.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


/********************************************************************************
 * Copyright (C) 2020 TypeFox, EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const theia_updater_frontend_contribution_1 = __webpack_require__(/*! ./updater/theia-updater-frontend-contribution */ "../../theia-extensions/updater/lib/electron-browser/updater/theia-updater-frontend-contribution.js");
const theia_updater_1 = __webpack_require__(/*! ../common/updater/theia-updater */ "../../theia-extensions/updater/lib/common/updater/theia-updater.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const electron_ipc_connection_source_1 = __webpack_require__(/*! @theia/core/lib/electron-browser/messaging/electron-ipc-connection-source */ "../../node_modules/@theia/core/lib/electron-browser/messaging/electron-ipc-connection-source.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const theia_updater_preferences_1 = __webpack_require__(/*! ./updater/theia-updater-preferences */ "../../theia-extensions/updater/lib/electron-browser/updater/theia-updater-preferences.js");
exports["default"] = new inversify_1.ContainerModule((bind, _unbind, isBound, rebind) => {
    bind(theia_updater_frontend_contribution_1.ElectronMenuUpdater).toSelf().inSingletonScope();
    bind(theia_updater_frontend_contribution_1.TheiaUpdaterClientImpl).toSelf().inSingletonScope();
    bind(theia_updater_1.TheiaUpdaterClient).toService(theia_updater_frontend_contribution_1.TheiaUpdaterClientImpl);
    bind(theia_updater_1.TheiaUpdater).toDynamicValue(context => {
        const client = context.container.get(theia_updater_frontend_contribution_1.TheiaUpdaterClientImpl);
        return electron_ipc_connection_source_1.ElectronIpcConnectionProvider.createProxy(context.container, theia_updater_1.TheiaUpdaterPath, client);
    }).inSingletonScope();
    bind(theia_updater_frontend_contribution_1.TheiaUpdaterFrontendContribution).toSelf().inSingletonScope();
    bind(common_1.MenuContribution).toService(theia_updater_frontend_contribution_1.TheiaUpdaterFrontendContribution);
    bind(common_1.CommandContribution).toService(theia_updater_frontend_contribution_1.TheiaUpdaterFrontendContribution);
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: theia_updater_preferences_1.theiaUpdaterPreferenceSchema });
});


/***/ }),

/***/ "../../theia-extensions/updater/lib/electron-browser/updater/theia-updater-frontend-contribution.js":
/*!**********************************************************************************************************!*\
  !*** ../../theia-extensions/updater/lib/electron-browser/updater/theia-updater-frontend-contribution.js ***!
  \**********************************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/********************************************************************************
 * Copyright (C) 2020 TypeFox, EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TheiaUpdaterFrontendContribution = exports.ElectronMenuUpdater = exports.TheiaUpdaterClientImpl = exports.TheiaUpdaterMenu = exports.TheiaUpdaterCommands = void 0;
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const preferences_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const theia_updater_1 = __webpack_require__(/*! ../../common/updater/theia-updater */ "../../theia-extensions/updater/lib/common/updater/theia-updater.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const electron_main_menu_factory_1 = __webpack_require__(/*! @theia/core/lib/electron-browser/menu/electron-main-menu-factory */ "../../node_modules/@theia/core/lib/electron-browser/menu/electron-main-menu-factory.js");
const uri_1 = __importDefault(__webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js"));
const vscode_uri_1 = __webpack_require__(/*! vscode-uri */ "../../node_modules/vscode-uri/lib/esm/index.js");
var TheiaUpdaterCommands;
(function (TheiaUpdaterCommands) {
    const category = 'Theia Electron Updater';
    TheiaUpdaterCommands.CHECK_FOR_UPDATES = {
        id: 'electron-theia:check-for-updates',
        label: 'Check for Updates...',
        category
    };
    TheiaUpdaterCommands.RESTART_TO_UPDATE = {
        id: 'electron-theia:restart-to-update',
        label: 'Restart to Update',
        category
    };
})(TheiaUpdaterCommands = exports.TheiaUpdaterCommands || (exports.TheiaUpdaterCommands = {}));
var TheiaUpdaterMenu;
(function (TheiaUpdaterMenu) {
    TheiaUpdaterMenu.MENU_PATH = [...browser_1.CommonMenus.FILE_SETTINGS_SUBMENU, '3_settings_submenu_update'];
})(TheiaUpdaterMenu = exports.TheiaUpdaterMenu || (exports.TheiaUpdaterMenu = {}));
let TheiaUpdaterClientImpl = class TheiaUpdaterClientImpl {
    constructor() {
        this.onReadyToInstallEmitter = new common_1.Emitter();
        this.onReadyToInstall = this.onReadyToInstallEmitter.event;
        this.onUpdateAvailableEmitter = new common_1.Emitter();
        this.onUpdateAvailable = this.onUpdateAvailableEmitter.event;
        this.onErrorEmitter = new common_1.Emitter();
        this.onError = this.onErrorEmitter.event;
    }
    notifyReadyToInstall() {
        this.onReadyToInstallEmitter.fire();
    }
    updateAvailable(available, startupCheck) {
        if (startupCheck) {
            // When we are checking for updates after program launch we need to check whether to prompt the user
            // we need to wait for the preference service. Also add a few seconds delay before showing the dialog
            this.preferenceService.ready
                .then(() => {
                setTimeout(() => {
                    const reportOnStart = this.preferenceService.get('updates.reportOnStart', true);
                    if (reportOnStart) {
                        this.onUpdateAvailableEmitter.fire(available);
                    }
                }, 10000);
            });
        }
        else {
            this.onUpdateAvailableEmitter.fire(available);
        }
    }
    reportError(error) {
        this.onErrorEmitter.fire(error);
    }
};
__decorate([
    (0, inversify_1.inject)(preferences_1.PreferenceService),
    __metadata("design:type", Object)
], TheiaUpdaterClientImpl.prototype, "preferenceService", void 0);
TheiaUpdaterClientImpl = __decorate([
    (0, inversify_1.injectable)()
], TheiaUpdaterClientImpl);
exports.TheiaUpdaterClientImpl = TheiaUpdaterClientImpl;
// Dynamic menus aren't yet supported by electron: https://github.com/eclipse-theia/theia/issues/446
let ElectronMenuUpdater = class ElectronMenuUpdater {
    update() {
        this.setMenu();
    }
    setMenu() {
        window.electronTheiaCore.setMenu(this.factory.createElectronMenuBar());
    }
};
__decorate([
    (0, inversify_1.inject)(electron_main_menu_factory_1.ElectronMainMenuFactory),
    __metadata("design:type", electron_main_menu_factory_1.ElectronMainMenuFactory)
], ElectronMenuUpdater.prototype, "factory", void 0);
ElectronMenuUpdater = __decorate([
    (0, inversify_1.injectable)()
], ElectronMenuUpdater);
exports.ElectronMenuUpdater = ElectronMenuUpdater;
let TheiaUpdaterFrontendContribution = class TheiaUpdaterFrontendContribution {
    constructor() {
        this.readyToUpdate = false;
    }
    init() {
        this.updaterClient.onUpdateAvailable(available => {
            if (available) {
                this.handleDownloadUpdate();
            }
            else {
                this.handleNoUpdate();
            }
        });
        this.updaterClient.onReadyToInstall(async () => {
            this.readyToUpdate = true;
            this.menuUpdater.update();
            this.handleUpdatesAvailable();
        });
        this.updaterClient.onError(error => this.handleError(error));
    }
    registerCommands(registry) {
        registry.registerCommand(TheiaUpdaterCommands.CHECK_FOR_UPDATES, {
            execute: async () => {
                this.updater.checkForUpdates();
            },
            isEnabled: () => !this.readyToUpdate,
            isVisible: () => !this.readyToUpdate
        });
        registry.registerCommand(TheiaUpdaterCommands.RESTART_TO_UPDATE, {
            execute: () => this.updater.onRestartToUpdateRequested(),
            isEnabled: () => this.readyToUpdate,
            isVisible: () => this.readyToUpdate
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(TheiaUpdaterMenu.MENU_PATH, {
            commandId: TheiaUpdaterCommands.CHECK_FOR_UPDATES.id
        });
        registry.registerMenuAction(TheiaUpdaterMenu.MENU_PATH, {
            commandId: TheiaUpdaterCommands.RESTART_TO_UPDATE.id
        });
    }
    async handleDownloadUpdate() {
        const answer = await this.messageService.info('Updates found, do you want to update?', 'No', 'Yes', 'Never');
        if (answer === 'Never') {
            this.preferenceService.set('updates.reportOnStart', false, preferences_1.PreferenceScope.User);
            return;
        }
        if (answer === 'Yes') {
            this.stopProgress();
            this.progress = await this.messageService.showProgress({
                text: 'Blueprint Update'
            });
            let dots = 0;
            this.intervalId = setInterval(() => {
                if (this.progress !== undefined) {
                    dots = (dots + 1) % 4;
                    this.progress.report({ message: 'Downloading' + '.'.repeat(dots) });
                }
            }, 1000);
            this.updater.downloadUpdate();
        }
    }
    async handleNoUpdate() {
        this.messageService.info('Already using the latest version');
    }
    async handleUpdatesAvailable() {
        if (this.progress !== undefined) {
            this.progress.report({ work: { done: 1, total: 1 } });
            this.stopProgress();
        }
        const answer = await this.messageService.info('An update has been downloaded and will be automatically installed on exit. Do you want to restart now?', 'No', 'Yes');
        if (answer === 'Yes') {
            this.updater.onRestartToUpdateRequested();
        }
    }
    async handleError(error) {
        this.stopProgress();
        if (error.errorLogPath) {
            const viewLogAction = 'View Error Log';
            const answer = await this.messageService.error(error.message, viewLogAction);
            if (answer === viewLogAction) {
                const uri = new uri_1.default(vscode_uri_1.URI.file(error.errorLogPath));
                const opener = await this.openerService.getOpener(uri);
                opener.open(uri);
            }
        }
        else {
            this.messageService.error(error.message);
        }
    }
    stopProgress() {
        if (this.intervalId !== undefined) {
            clearInterval(this.intervalId);
            this.intervalId = undefined;
        }
        if (this.progress !== undefined) {
            this.progress.cancel();
            this.progress = undefined;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(common_1.MessageService),
    __metadata("design:type", common_1.MessageService)
], TheiaUpdaterFrontendContribution.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(ElectronMenuUpdater),
    __metadata("design:type", ElectronMenuUpdater)
], TheiaUpdaterFrontendContribution.prototype, "menuUpdater", void 0);
__decorate([
    (0, inversify_1.inject)(theia_updater_1.TheiaUpdater),
    __metadata("design:type", Object)
], TheiaUpdaterFrontendContribution.prototype, "updater", void 0);
__decorate([
    (0, inversify_1.inject)(TheiaUpdaterClientImpl),
    __metadata("design:type", TheiaUpdaterClientImpl)
], TheiaUpdaterFrontendContribution.prototype, "updaterClient", void 0);
__decorate([
    (0, inversify_1.inject)(preferences_1.PreferenceService),
    __metadata("design:type", Object)
], TheiaUpdaterFrontendContribution.prototype, "preferenceService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    __metadata("design:type", Object)
], TheiaUpdaterFrontendContribution.prototype, "openerService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TheiaUpdaterFrontendContribution.prototype, "init", null);
TheiaUpdaterFrontendContribution = __decorate([
    (0, inversify_1.injectable)()
], TheiaUpdaterFrontendContribution);
exports.TheiaUpdaterFrontendContribution = TheiaUpdaterFrontendContribution;


/***/ }),

/***/ "../../theia-extensions/updater/lib/electron-browser/updater/theia-updater-preferences.js":
/*!************************************************************************************************!*\
  !*** ../../theia-extensions/updater/lib/electron-browser/updater/theia-updater-preferences.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * SPDX-License-Identifier: MIT
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.theiaUpdaterPreferenceSchema = void 0;
exports.theiaUpdaterPreferenceSchema = {
    'type': 'object',
    'properties': {
        'updates.reportOnStart': {
            type: 'boolean',
            description: 'Report available updates after application start.',
            default: true
        }
    }
};


/***/ })

}]);
//# sourceMappingURL=theia-extensions_updater_lib_electron-browser_theia-updater-frontend-module_js.js.map