"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphArrow = exports.TimeGraphModel = exports.TimeGraphRow = exports.TimeGraphEntry = void 0;
const serialization_1 = require("../protocol/serialization");
const styles_1 = require("./styles");
exports.TimeGraphEntry = (0, serialization_1.createNormalizer)({
    end: BigInt,
    id: serialization_1.assertNumber,
    parentId: serialization_1.assertNumber,
    start: BigInt,
    style: styles_1.OutputElementStyle,
    metadata: undefined,
});
const TimeGraphState = (0, serialization_1.createNormalizer)({
    end: BigInt,
    start: BigInt,
    tags: serialization_1.assertNumber,
    style: styles_1.OutputElementStyle,
});
exports.TimeGraphRow = (0, serialization_1.createNormalizer)({
    entryId: serialization_1.assertNumber,
    states: (0, serialization_1.array)(TimeGraphState),
});
exports.TimeGraphModel = (0, serialization_1.createNormalizer)({
    rows: (0, serialization_1.array)(exports.TimeGraphRow),
});
exports.TimeGraphArrow = (0, serialization_1.createNormalizer)({
    end: BigInt,
    sourceId: serialization_1.assertNumber,
    start: BigInt,
    targetId: serialization_1.assertNumber,
    style: styles_1.OutputElementStyle,
});
//# sourceMappingURL=timegraph.js.map