"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphLayer = void 0;
var PIXI = require("pixi.js-legacy");
var TimeGraphLayer = /** @class */ (function () {
    function TimeGraphLayer(id) {
        this.id = id;
        this.children = [];
        this.layer = new PIXI.Container();
    }
    TimeGraphLayer.prototype.addChild = function (child, parent) {
        if (!this.canvas) {
            throw ("Layers must be added to a container before components can be added.");
        }
        child.update();
        if (parent) {
            parent.addChild(child);
        }
        else {
            if (!this.childContainer) {
                this.childContainer = new PIXI.Container();
                this.layer.addChild(this.childContainer);
            }
            this.childContainer.addChild(child.displayObject);
            this.children.push(child);
        }
    };
    /**
    This method is called by the container this layer is added to.
    */
    TimeGraphLayer.prototype.initializeLayer = function (canvas, stage, stateController, unitController) {
        this.canvas = canvas;
        this.stateController = stateController;
        this.unitController = unitController;
        this.stage = stage;
        stage.addChild(this.layer);
        this.afterAddToContainer();
    };
    TimeGraphLayer.prototype.onCanvasEvent = function (type, handler) {
        this.canvas.addEventListener(type, handler);
    };
    TimeGraphLayer.prototype.removeOnCanvasEvent = function (type, handler) {
        this.canvas.removeEventListener(type, handler);
    };
    TimeGraphLayer.prototype.removeChildren = function () {
        var _a;
        (_a = this.childContainer) === null || _a === void 0 ? void 0 : _a.destroy({ children: true });
        this.childContainer = undefined;
        this.children = [];
    };
    TimeGraphLayer.prototype.removeChild = function (child) {
        var _a;
        (_a = this.childContainer) === null || _a === void 0 ? void 0 : _a.removeChild(child.displayObject);
        child.destroy();
        var idx = this.children.findIndex(function (c) { return c === child; });
        idx && this.children.splice(idx, 1);
    };
    TimeGraphLayer.prototype.getPixel = function (time) {
        var div = 0x100000000;
        var hi = Number(time / BigInt(div));
        var lo = Number(time % BigInt(div));
        return Math.floor(hi * this.stateController.zoomFactor * div + lo * this.stateController.zoomFactor);
    };
    TimeGraphLayer.prototype.afterAddToContainer = function () { };
    TimeGraphLayer.prototype.destroy = function () {
        this.layer.destroy({ children: true });
        this.childContainer = undefined;
        this.children = [];
    };
    return TimeGraphLayer;
}());
exports.TimeGraphLayer = TimeGraphLayer;
//# sourceMappingURL=time-graph-layer.js.map