"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GotoLineAction = exports.StandaloneCommandsQuickAccessProvider = void 0;
const platform_1 = require("../../../../platform/registry/common/platform");
const quickAccess_1 = require("../../../../platform/quickinput/common/quickAccess");
const standaloneStrings_1 = require("../../../common/standaloneStrings");
const codeEditorService_1 = require("../../../browser/services/codeEditorService");
const commandsQuickAccess_1 = require("../../../contrib/quickAccess/browser/commandsQuickAccess");
const types_1 = require("../../../../base/common/types");
const instantiation_1 = require("../../../../platform/instantiation/common/instantiation");
const keybinding_1 = require("../../../../platform/keybinding/common/keybinding");
const commands_1 = require("../../../../platform/commands/common/commands");
const telemetry_1 = require("../../../../platform/telemetry/common/telemetry");
const dialogs_1 = require("../../../../platform/dialogs/common/dialogs");
const editorExtensions_1 = require("../../../browser/editorExtensions");
const editorContextKeys_1 = require("../../../common/editorContextKeys");
const quickInput_1 = require("../../../../platform/quickinput/common/quickInput");
let StandaloneCommandsQuickAccessProvider = class StandaloneCommandsQuickAccessProvider extends commandsQuickAccess_1.AbstractEditorCommandsQuickAccessProvider {
    constructor(instantiationService, codeEditorService, keybindingService, commandService, telemetryService, dialogService) {
        super({ showAlias: false }, instantiationService, keybindingService, commandService, telemetryService, dialogService);
        this.codeEditorService = codeEditorService;
    }
    get activeTextEditorControl() { return (0, types_1.withNullAsUndefined)(this.codeEditorService.getFocusedCodeEditor()); }
    getCommandPicks() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.getCodeEditorCommandPicks();
        });
    }
};
StandaloneCommandsQuickAccessProvider = __decorate([
    __param(0, instantiation_1.IInstantiationService),
    __param(1, codeEditorService_1.ICodeEditorService),
    __param(2, keybinding_1.IKeybindingService),
    __param(3, commands_1.ICommandService),
    __param(4, telemetry_1.ITelemetryService),
    __param(5, dialogs_1.IDialogService)
], StandaloneCommandsQuickAccessProvider);
exports.StandaloneCommandsQuickAccessProvider = StandaloneCommandsQuickAccessProvider;
platform_1.Registry.as(quickAccess_1.Extensions.Quickaccess).registerQuickAccessProvider({
    ctor: StandaloneCommandsQuickAccessProvider,
    prefix: StandaloneCommandsQuickAccessProvider.PREFIX,
    helpEntries: [{ description: standaloneStrings_1.QuickCommandNLS.quickCommandHelp, needsEditor: true }]
});
class GotoLineAction extends editorExtensions_1.EditorAction {
    constructor() {
        super({
            id: 'editor.action.quickCommand',
            label: standaloneStrings_1.QuickCommandNLS.quickCommandActionLabel,
            alias: 'Command Palette',
            precondition: undefined,
            kbOpts: {
                kbExpr: editorContextKeys_1.EditorContextKeys.focus,
                primary: 59 /* KeyCode.F1 */,
                weight: 100 /* KeybindingWeight.EditorContrib */
            },
            contextMenuOpts: {
                group: 'z_commands',
                order: 1
            }
        });
    }
    run(accessor) {
        accessor.get(quickInput_1.IQuickInputService).quickAccess.show(StandaloneCommandsQuickAccessProvider.PREFIX);
    }
}
exports.GotoLineAction = GotoLineAction;
(0, editorExtensions_1.registerEditorAction)(GotoLineAction);
//# sourceMappingURL=standaloneCommandsQuickAccess.js.map