/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.PatternVerifier;

public class IgnoreMethodPanel
extends AbstractDialogPanel {
    protected int ignoreType;
    protected String ignorePattern;
    protected IResource[] resources;
    protected Button patternButton;
    protected Text ignorePatternField;

    public IgnoreMethodPanel(IResource[] resources) {
        if (resources.length == 1) {
            this.dialogTitle = SVNUIMessages.IgnoreMethodPanel_Title_Single;
            this.dialogDescription = SVNUIMessages.IgnoreMethodPanel_Description_Single;
        } else {
            this.dialogTitle = SVNUIMessages.IgnoreMethodPanel_Title_Multi;
            this.dialogDescription = SVNUIMessages.IgnoreMethodPanel_Description_Multi;
        }
        this.defaultMessage = SVNUIMessages.IgnoreMethodPanel_Message;
        this.ignoreType = 0;
        this.ignorePattern = null;
        this.resources = resources;
    }

    public int getIgnoreType() {
        return this.ignoreType;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void createControlsImpl(Composite parent) {
        GridData data = null;
        Button nameButton = new Button(parent, 16);
        data = new GridData(768);
        nameButton.setLayoutData((Object)data);
        String text = SVNUIMessages.format((String)(this.resources.length == 1 ? SVNUIMessages.IgnoreMethodPanel_Name_Single : SVNUIMessages.IgnoreMethodPanel_Name_Multi), (Object[])new String[]{this.resources[0].getName()});
        nameButton.setText(text);
        nameButton.setSelection(true);
        nameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnoreMethodPanel.this.ignoreType = 0;
                IgnoreMethodPanel.this.ignorePatternField.setEnabled(false);
            }
        });
        Button extensionButton = new Button(parent, 16);
        data = new GridData(768);
        extensionButton.setLayoutData((Object)data);
        String extension = null;
        int i = 0;
        while (i < this.resources.length) {
            if (extension != null) break;
            extension = this.resources[i].getFileExtension();
            ++i;
        }
        text = SVNUIMessages.format((String)(this.resources.length == 1 ? SVNUIMessages.IgnoreMethodPanel_Extension_Single : SVNUIMessages.IgnoreMethodPanel_Extension_Multi), (Object[])new String[]{extension == null ? "" : extension});
        extensionButton.setText(text);
        extensionButton.setSelection(false);
        extensionButton.setEnabled(extension != null);
        extensionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnoreMethodPanel.this.ignoreType = 1;
                IgnoreMethodPanel.this.ignorePatternField.setEnabled(false);
            }
        });
        this.patternButton = new Button(parent, 16);
        data = new GridData(768);
        this.patternButton.setLayoutData((Object)data);
        text = SVNUIMessages.format((String)SVNUIMessages.IgnoreMethodPanel_Pattern, (Object[])new String[]{this.resources[0].getName().substring(1)});
        this.patternButton.setText(text);
        this.patternButton.setSelection(false);
        this.patternButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnoreMethodPanel.this.ignoreType = 2;
                IgnoreMethodPanel.this.ignorePatternField.setEnabled(true);
            }
        });
        this.ignorePatternField = new Text(parent, 2052);
        data = new GridData(768);
        this.ignorePatternField.setLayoutData((Object)data);
        this.ignorePatternField.setEnabled(false);
        this.ignorePatternField.setText(this.resources[0].getName());
        this.attachTo((Control)this.ignorePatternField, new AbstractVerifierProxy(new PatternVerifier(SVNUIMessages.IgnoreMethodPanel_Pattern_Verifier, this.resources)){

            protected boolean isVerificationEnabled(Control input) {
                return IgnoreMethodPanel.this.patternButton.getSelection();
            }
        });
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.addToIgnoreDialogContext";
    }

    public Point getPrefferedSizeImpl() {
        return new Point(470, 130);
    }

    protected void saveChangesImpl() {
        this.ignorePattern = this.patternButton.getSelection() ? this.ignorePatternField.getText() : null;
    }

    protected void cancelChangesImpl() {
    }
}

