/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.core.tests.parser;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodCallStatement;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclMethodDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclObjectDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclVariableDeclaration;
import org.eclipse.dltk.xotcl.core.tests.parser.TclCommandProcessorTests;
import org.eclipse.dltk.xotcl.core.tests.parser.TestTclParser;
import org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl.XOTclClassAllProcProcessor;
import org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl.XOTclClassMethodCallProcessor;
import org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl.XOTclClassNewInstanceProcessor;
import org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl.XOTclClassProcessor;
import org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl.XOTclObjectCreateProcessor;
import org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl.XOTclObjectSetProcessor;

public class XOTclCommandProcessorTests
extends TestCase {
    public void testClassCreateCommandProcessor005() throws Throwable {
        String content1 = "Class ClubMember -superclass MySuperClass -parameter {title goal {name \"\"}}";
        String content2 = "Class create ClubMember -superclass MySuperClass -parameter {title goal {name \"\"}}";
        this.testClassCreateCommandProcessor(this.process(content1, (AbstractTclCommandProcessor)new XOTclClassProcessor()));
        this.testClassCreateCommandProcessor(this.process(content2, (AbstractTclCommandProcessor)new XOTclClassProcessor()));
    }

    private void testClassCreateCommandProcessor(ASTNode statement) {
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof TypeDeclaration));
        TypeDeclaration type = (TypeDeclaration)statement;
        XOTclCommandProcessorTests.assertEquals((String)"ClubMember", (String)type.getName());
        List superClassNames = type.getSuperClassNames();
        XOTclCommandProcessorTests.assertNotNull((Object)superClassNames);
        XOTclCommandProcessorTests.assertNotNull(superClassNames.get(0));
        XOTclCommandProcessorTests.assertTrue((boolean)(superClassNames.get(0) instanceof String));
        XOTclCommandProcessorTests.assertEquals((String)"MySuperClass", (String)((String)superClassNames.get(0)));
        FieldDeclaration[] fields = type.getVariables();
        XOTclCommandProcessorTests.assertTrue((3 == fields.length ? 1 : 0) != 0);
        XOTclCommandProcessorTests.assertEquals((String)"title", (String)fields[0].getName());
        XOTclCommandProcessorTests.assertEquals((String)"goal", (String)fields[1].getName());
        XOTclCommandProcessorTests.assertEquals((String)"name", (String)fields[2].getName());
    }

    private ASTNode process(String content, AbstractTclCommandProcessor processor) throws TclParseException {
        TclStatement ifCommand = TclCommandProcessorTests.toCommand(content);
        TestTclParser testParser = new TestTclParser(content);
        ASTNode statement = processor.process(ifCommand, (ITclParser)testParser, null);
        return statement;
    }

    public void testObjectCreateProcessor() throws TclParseException {
        String content1 = "Object obj";
        String content2 = "Object create obj";
        XOTclObjectCreateProcessor processor = new XOTclObjectCreateProcessor();
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content1), (ITclParser)new TestTclParser(content1), null);
        this.testObjectCreateProcessor(statement);
        statement = processor.process(TclCommandProcessorTests.toCommand(content2), (ITclParser)new TestTclParser(content2), null);
        this.testObjectCreateProcessor(statement);
    }

    private void testObjectCreateProcessor(ASTNode statement) {
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof XOTclObjectDeclaration));
        XOTclObjectDeclaration decl = (XOTclObjectDeclaration)statement;
        XOTclCommandProcessorTests.assertEquals((String)"obj", (String)decl.getName());
        XOTclCommandProcessorTests.assertTrue(((0x80000 & decl.getModifiers()) != 0 ? 1 : 0) != 0);
        XOTclCommandProcessorTests.assertTrue(((0x100000 & decl.getModifiers()) != 0 ? 1 : 0) != 0);
    }

    public void testObjectSetProcessor() throws TclParseException {
        String content = "obj set field value";
        XOTclObjectSetProcessor processor = new XOTclObjectSetProcessor();
        processor.setDetectedParameter((Object)new TypeDeclaration("Object", 0, 0, 0, 0));
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content), (ITclParser)new TestTclParser(content), null);
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof FieldDeclaration));
        XOTclVariableDeclaration decl = (XOTclVariableDeclaration)statement;
        XOTclCommandProcessorTests.assertEquals((String)"Object", (String)decl.getDeclaringTypeName());
        XOTclCommandProcessorTests.assertEquals((String)"field", (String)decl.getName());
        XOTclCommandProcessorTests.assertTrue(((0x80000 & decl.getModifiers()) != 0 ? 1 : 0) != 0);
    }

    public void testXOTclProcCallProcessor() throws TclParseException {
        String content = "obj procedure arg0";
        XOTclClassMethodCallProcessor processor = new XOTclClassMethodCallProcessor();
        processor.setDetectedParameter((Object)new XOTclInstanceVariable("obj", 0, 0, 0, 0));
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content), (ITclParser)new TestTclParser(content), null);
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof XOTclMethodCallStatement));
        XOTclMethodCallStatement methodCall = (XOTclMethodCallStatement)statement;
        XOTclCommandProcessorTests.assertEquals((String)"procedure", (String)methodCall.getCallName().getName());
        CallArgumentsList arguments = methodCall.getArgs();
        XOTclCommandProcessorTests.assertEquals((int)1, (int)arguments.getChilds().size());
    }

    public void testXOTclClassNewInstanceProcessor() throws TclParseException {
        String content = "ClassName create inst";
        XOTclClassNewInstanceProcessor processor = new XOTclClassNewInstanceProcessor();
        processor.setDetectedParameter((Object)new TypeDeclaration("ClassName", 0, 0, 0, 0));
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content), (ITclParser)new TestTclParser(content), null);
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof XOTclInstanceVariable));
        XOTclInstanceVariable var = (XOTclInstanceVariable)statement;
        XOTclCommandProcessorTests.assertEquals((String)"inst", (String)var.getName());
        XOTclCommandProcessorTests.assertTrue(((0x80000 & var.getModifiers()) != 0 ? 1 : 0) != 0);
    }

    public void testXOtclClassMethodCallProcessor() throws TclParseException {
        String content = "Foo bar arg0";
        XOTclClassMethodCallProcessor processor = new XOTclClassMethodCallProcessor();
        processor.setDetectedParameter((Object)new XOTclInstanceVariable("Foo", 0, 0, 0, 0));
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content), (ITclParser)new TestTclParser(content), null);
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof XOTclMethodCallStatement));
        XOTclMethodCallStatement methodCall = (XOTclMethodCallStatement)statement;
        XOTclCommandProcessorTests.assertEquals((String)"bar", (String)methodCall.getCallName().getName());
        XOTclCommandProcessorTests.assertEquals((int)1, (int)methodCall.getArgs().getChilds().size());
    }

    public void testXOTclClassAllProcProcessor001() throws TclParseException {
        String content = "Foo proc bar {arg0} {}";
        this.testXOTclClassAllProcProcessor(content, new TypeDeclaration("Foo", 0, 0, 0, 0));
    }

    public void testXOTclClassAllProcProcessor002() throws TclParseException {
        String content = "Foo instproc bar {arg0} {}";
        this.testXOTclClassAllProcProcessor(content, new TypeDeclaration("Foo", 0, 0, 0, 0));
    }

    public void testXOTclClassAllProcProcessor003() throws TclParseException {
        String content = "obj proc bar {arg0} {}";
        this.testXOTclClassAllProcProcessor(content, new XOTclInstanceVariable("obj", 0, 0, 0, 0));
    }

    public void testXOTclClassAllProcProcessor004() throws TclParseException {
        String content = "Object proc bar {arg0} {}";
        XOTclClassAllProcProcessor processor = new XOTclClassAllProcProcessor();
        processor.setDetectedParameter((Object)new TypeDeclaration("Object", 0, 0, 0, 0));
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content), (ITclParser)new TestTclParser(content), null);
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof XOTclMethodDeclaration));
        ExtendedTclMethodDeclaration decl = (ExtendedTclMethodDeclaration)statement;
        XOTclCommandProcessorTests.assertEquals((String)"Object", (String)decl.getDeclaringTypeName());
        XOTclCommandProcessorTests.assertEquals((String)"bar", (String)decl.getName());
        XOTclCommandProcessorTests.assertEquals((int)1, (int)decl.getArguments().size());
        XOTclCommandProcessorTests.assertTrue(((0x80000 & decl.getModifiers()) != 0 ? 1 : 0) != 0);
    }

    private void testXOTclClassAllProcProcessor(String content, Object parameter) throws TclParseException {
        XOTclClassAllProcProcessor processor = new XOTclClassAllProcProcessor();
        processor.setDetectedParameter(parameter);
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(content), (ITclParser)new TestTclParser(content), null);
        XOTclCommandProcessorTests.assertNotNull((Object)statement);
        XOTclCommandProcessorTests.assertTrue((boolean)(statement instanceof XOTclMethodDeclaration));
        ExtendedTclMethodDeclaration decl = (ExtendedTclMethodDeclaration)statement;
        if (parameter instanceof TypeDeclaration) {
            XOTclCommandProcessorTests.assertEquals((String)"Foo", (String)decl.getDeclaringTypeName());
        } else if (parameter instanceof FieldDeclaration) {
            XOTclCommandProcessorTests.assertEquals((String)"obj", (String)decl.getDeclaringTypeName());
        }
        XOTclCommandProcessorTests.assertEquals((String)"bar", (String)decl.getName());
        XOTclCommandProcessorTests.assertEquals((int)1, (int)decl.getArguments().size());
        XOTclCommandProcessorTests.assertTrue(((0x80000 & decl.getModifiers()) != 0 ? 1 : 0) != 0);
    }
}

