/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.core.tests.parser;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.IfStatement;
import org.eclipse.dltk.tcl.core.ast.TclCatchStatement;
import org.eclipse.dltk.tcl.core.ast.TclForStatement;
import org.eclipse.dltk.tcl.core.ast.TclGlobalVariableDeclaration;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.core.ast.TclSwitchStatement;
import org.eclipse.dltk.tcl.core.ast.TclUpvarVariableDeclaration;
import org.eclipse.dltk.tcl.core.ast.TclVariableDeclaration;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclCatchProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclForCommandProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclGlobalVariableProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclIfProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclNamespaceProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclPackageProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclProcProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclSwitchCommandProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclUpvarProcessor;
import org.eclipse.dltk.tcl.internal.core.parser.processors.tcl.TclVariableProcessor;
import org.eclipse.dltk.tcl.internal.parsers.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclScript;
import org.eclipse.dltk.xotcl.core.tests.parser.TestTclParser;

public class TclCommandProcessorTests
extends TestCase {
    static TclStatement toCommand(String content) throws TclParseException {
        TclScript parse = SimpleTclParser.parse((String)content);
        List commands = parse.getCommands();
        TclCommandProcessorTests.assertEquals((int)1, (int)commands.size());
        TclCommandProcessorTests.assertNotNull(commands.get(0));
        TestTclParser p = new TestTclParser(content);
        return p.processLocal((TclCommand)commands.get(0), 0, null);
    }

    public void testIfProcessor001() throws Throwable {
        String content = "if {a < 2} {\n\tset b 20\n} else {\n\tset b 10\n\tset d 30\n}\n";
        this.processTestIf001(content);
    }

    public void testIfProcessor001a() throws Throwable {
        String content = "if {a < 2} then {\n\tset b 20\n} else {\n\tset b 10\n\tset d 30\n}\n";
        this.processTestIf001(content);
    }

    private void testCondition(IfStatement ifStatement) {
        TclCommandProcessorTests.assertNotNull((Object)ifStatement.getCondition());
        TclCommandProcessorTests.assertEquals((boolean)true, (boolean)(ifStatement.getCondition() instanceof ASTListNode));
        ASTListNode condition = (ASTListNode)ifStatement.getCondition();
        TclCommandProcessorTests.assertEquals((int)3, (int)condition.getChilds().size());
        TclCommandProcessorTests.assertTrue((boolean)(condition.getChilds().get(0) instanceof SimpleReference));
        TclCommandProcessorTests.assertTrue((boolean)(condition.getChilds().get(1) instanceof SimpleReference));
        TclCommandProcessorTests.assertTrue((boolean)(condition.getChilds().get(2) instanceof SimpleReference));
    }

    private void processTestIf001(String content) throws TclParseException {
        TestTclParser testParser = new TestTclParser(content);
        TclStatement ifCommand = TclCommandProcessorTests.toCommand(content);
        TclIfProcessor ifProcessor = new TclIfProcessor();
        ASTNode statement = ifProcessor.process(ifCommand, (ITclParser)testParser, null);
        TclCommandProcessorTests.assertNotNull((Object)statement);
        TclCommandProcessorTests.assertEquals((boolean)true, (boolean)(statement instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)statement;
        this.testCondition(ifStatement);
        this.assertBlockWithSize((ASTNode)ifStatement.getThen(), 1);
        this.assertBlockWithSize(ifStatement.getElse(), 2);
    }

    private void assertBlockWithSize(ASTNode then, int size) {
        TclCommandProcessorTests.assertNotNull((Object)then);
        List childs = then.getChilds();
        TclCommandProcessorTests.assertNotNull((Object)childs);
        TclCommandProcessorTests.assertEquals((int)size, (int)childs.size());
    }

    public void testIfProcessor002() throws Throwable {
        String content = "if {a < 2} {\n\tset b 20\n} elseif { a == 4 } {\n\tset b 10\n\tset d 30\n} else {\n\tset d 90\n\tset f 10\n\tset a 0\n}";
        this.processTestIf002(content);
    }

    public void testIfProcessor002a() throws Throwable {
        String content = "if {a < 2} then {\n\tset b 20\n} elseif { a == 4 } {\n\tset b 10\n\tset d 30\n} else {\n\tset d 90\n\tset f 10\n\tset a 0\n}\n";
        this.processTestIf002(content);
    }

    public void testIfProcessor003() throws Throwable {
        String content = "if {a < 2} {\n\tset b 20\n} elseif { a == 4 } then {\n\tset b 10\n\tset d 30\n} else {\n\tset d 90\n\tset f 10\n\tset a 0\n}\n";
        this.processTestIf002(content);
    }

    private void processTestIf002(String content) throws TclParseException {
        TestTclParser testParser = new TestTclParser(content);
        TclStatement ifCommand = TclCommandProcessorTests.toCommand(content);
        TclIfProcessor ifProcessor = new TclIfProcessor();
        ASTNode statement = ifProcessor.process(ifCommand, (ITclParser)testParser, null);
        TclCommandProcessorTests.assertNotNull((Object)statement);
        TclCommandProcessorTests.assertEquals((boolean)true, (boolean)(statement instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)statement;
        this.testCondition(ifStatement);
        this.assertBlockWithSize((ASTNode)ifStatement.getThen(), 1);
        ASTNode else1 = ifStatement.getElse();
        TclCommandProcessorTests.assertNotNull((Object)else1);
        TclCommandProcessorTests.assertEquals((boolean)true, (boolean)(else1 instanceof IfStatement));
        IfStatement elseStatement = (IfStatement)else1;
        this.assertBlockWithSize((ASTNode)elseStatement.getThen(), 2);
        this.assertBlockWithSize(elseStatement.getElse(), 3);
    }

    public void testIfProcessor004() throws Throwable {
        String content = "if {a < 2} then {\n\tset b 20\n}\n";
        TestTclParser testParser = new TestTclParser(content);
        TclStatement ifCommand = TclCommandProcessorTests.toCommand(content);
        TclIfProcessor ifProcessor = new TclIfProcessor();
        ASTNode statement = ifProcessor.process(ifCommand, (ITclParser)testParser, null);
        TclCommandProcessorTests.assertNotNull((Object)statement);
        TclCommandProcessorTests.assertEquals((boolean)true, (boolean)(statement instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)statement;
        this.testCondition(ifStatement);
        this.assertBlockWithSize((ASTNode)ifStatement.getThen(), 1);
    }

    public void testTclCatchProcessor001() throws TclParseException {
        String script = "catch {} var";
        this.testTclCatchProcessor(script, true);
    }

    public void testTclCatchProcessor002() throws TclParseException {
        String script = "catch {}";
        this.testTclCatchProcessor(script, false);
    }

    public void testTclCatchProcessor003() throws TclParseException {
        String script = "catch pid a";
        this.testTclCatchProcessor(script, true);
    }

    public void testTclCatchProcessor004() throws TclParseException {
        String script = "catch pid";
        this.testTclCatchProcessor(script, false);
    }

    private void testTclCatchProcessor(String script, boolean withVariable) throws TclParseException {
        TclCatchProcessor processor = new TclCatchProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclCommandProcessorTests.assertTrue((boolean)(node instanceof TclCatchStatement));
        TclCatchStatement catchSatement = (TclCatchStatement)node;
        if (withVariable) {
            TclCommandProcessorTests.assertEquals((int)2, (int)catchSatement.getChilds().size());
            TclCommandProcessorTests.assertTrue((boolean)(catchSatement.getChilds().get(1) instanceof TclVariableDeclaration));
        } else {
            TclCommandProcessorTests.assertEquals((int)1, (int)catchSatement.getChilds().size());
        }
        TclCommandProcessorTests.assertTrue((boolean)(catchSatement.getChilds().get(0) instanceof Block));
    }

    public void testTclGlobalVariableProcessor001() throws TclParseException {
        String script = "global var0 var1";
        this.testTclGlobalVariableProcessor(script, 2);
    }

    public void testTclGlobalVariableProcessor002() throws TclParseException {
        String script = "global var";
        this.testTclGlobalVariableProcessor(script, 1);
    }

    private void testTclGlobalVariableProcessor(String script, int varNum) throws TclParseException {
        TclGlobalVariableProcessor processor = new TclGlobalVariableProcessor();
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)statement);
        TclCommandProcessorTests.assertTrue((statement instanceof TclGlobalVariableDeclaration || statement instanceof Block ? 1 : 0) != 0);
        if (statement instanceof ASTListNode) {
            ASTListNode list = (ASTListNode)statement;
            TclCommandProcessorTests.assertEquals((int)varNum, (int)list.getChilds().size());
            Iterator i = list.getChilds().iterator();
            while (i.hasNext()) {
                TclCommandProcessorTests.assertTrue((boolean)(i.next() instanceof TclGlobalVariableDeclaration));
            }
        }
    }

    public void testTclPackageProcessor001() throws TclParseException {
        String script = "package ifneeded pack 1.0.1 {script}";
        this.testPackageImports(script, 1, true);
    }

    public void testTclPackageProcessor002() throws TclParseException {
        String script = "package ifneeded pack 1.0.1";
        this.testPackageImports(script, 1, false);
    }

    public void testTclPackageProcessor003() throws TclParseException {
        String script = "package require pack 1.0.1";
        this.testPackageImports(script, 2, false);
    }

    public void testTclPackageProcessor004() throws TclParseException {
        String script = "package require -exact pack 1.0.1";
        this.testPackageImports(script, 2, false);
    }

    public void testTclPackageProcessor005() throws TclParseException {
        String script = "package provide pack 1.0.1";
        this.testPackageImports(script, 0, false);
    }

    private void testPackageImports(String script, int style, boolean hasScript) throws TclParseException {
        TclPackageProcessor processor = new TclPackageProcessor();
        ASTNode statement = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)statement);
        TclCommandProcessorTests.assertTrue((boolean)(statement instanceof TclPackageDeclaration));
        TclPackageDeclaration decl = (TclPackageDeclaration)statement;
        TclCommandProcessorTests.assertEquals((int)style, (int)decl.getStyle());
        TclCommandProcessorTests.assertEquals((String)"pack", (String)decl.getName());
        TclCommandProcessorTests.assertEquals((String)"1.0.1", (String)((SimpleReference)decl.getVersion()).getName());
        if (hasScript) {
            TclCommandProcessorTests.assertNotNull((Object)decl.getScript());
        } else {
            TclCommandProcessorTests.assertNull((Object)decl.getScript());
        }
    }

    public void testTclProcProcessor001() throws TclParseException {
        String script = "proc func args { pid }";
        this.testTclProcProcessor(script, 1);
    }

    public void testTclProcProcessor002() throws TclParseException {
        String script = "proc func {arg0, {arg1 \"value\"} } { pid }";
        MethodDeclaration method = this.testTclProcProcessor(script, 2);
        TclCommandProcessorTests.assertNotNull((Object)((Argument)method.getArguments().get(1)));
    }

    public void testTclProcProcessor003() throws TclParseException {
        String script = "proc func {} { pid }";
        this.testTclProcProcessor(script, 0);
    }

    private MethodDeclaration testTclProcProcessor(String script, int argNum) throws TclParseException {
        TclProcProcessor processor = new TclProcProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclCommandProcessorTests.assertTrue((boolean)(node instanceof MethodDeclaration));
        MethodDeclaration method = (MethodDeclaration)node;
        TclCommandProcessorTests.assertEquals((String)"func", (String)method.getName());
        TclCommandProcessorTests.assertEquals((int)argNum, (int)method.getArguments().size());
        return method;
    }

    public void testTclVariableProcessor001() throws TclParseException {
        String script = "set var \"value\"";
        this.testTclVariableProcessor(script, true);
    }

    public void testTclVariableProcessor002() throws TclParseException {
        String script = "set var";
        this.testTclVariableProcessor(script, false);
    }

    private void testTclVariableProcessor(String script, boolean initialValue) throws TclParseException {
        TclVariableProcessor processor = new TclVariableProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclVariableDeclaration var = (TclVariableDeclaration)node;
        TclCommandProcessorTests.assertEquals((String)"var", (String)var.getName());
        if (initialValue) {
            TclCommandProcessorTests.assertNotNull((Object)var.getInitializer());
        }
    }

    public void testTclUpVarProcessor001() throws TclParseException {
        String script = "upvar otherVar0 myVar0";
        this.testTclUpVarProcessor(script, 1);
    }

    public void testTclUpVarProcessor002() throws TclParseException {
        String script = "upvar otherVar0 myVar0 otherVar1 myVar1";
        this.testTclUpVarProcessor(script, 2);
    }

    public void testTclUpVarProcessor003() throws TclParseException {
        String script = "upvar 1 otherVar0 myVar0";
        this.testTclUpVarProcessor(script, 1);
    }

    public void testTclUpVarProcessor004() throws TclParseException {
        String script = "upvar #1 otherVar0 myVar0";
        this.testTclUpVarProcessor(script, 1);
    }

    private void testTclUpVarProcessor(String script, int varNum) throws TclParseException {
        TclUpvarProcessor processor = new TclUpvarProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclCommandProcessorTests.assertTrue((node instanceof ASTListNode || node instanceof TclUpvarVariableDeclaration ? 1 : 0) != 0);
        if (node instanceof ASTListNode) {
            TclCommandProcessorTests.assertEquals((int)varNum, (int)((ASTListNode)node).getChilds().size());
        }
    }

    public void testTclNamespaceProcessor001() throws TclParseException {
        String script = "namespace eval :: pid";
        this.testTclNamespaceProcessor(script);
    }

    public void testTclNamespaceProcessor002() throws TclParseException {
        String script = "namespace eval :: {pid;} {puts boo!}";
        this.testTclNamespaceProcessor(script);
    }

    public void testTclNamespaceProcessor003() throws TclParseException {
        String script = "namespace eval :: {pid}";
        this.testTclNamespaceProcessor(script);
    }

    public void testTclNamespaceProcessor004() throws TclParseException {
        String script = "namespace eval :: puts boo!";
        this.testTclNamespaceProcessor(script);
    }

    private void testTclNamespaceProcessor(String script) throws TclParseException {
        TclNamespaceProcessor processor = new TclNamespaceProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclCommandProcessorTests.assertTrue((boolean)(node instanceof TypeDeclaration));
        TclCommandProcessorTests.assertTrue(((0x1000 & ((TypeDeclaration)node).getModifiers()) != 0 ? 1 : 0) != 0);
        TclCommandProcessorTests.assertNotNull((Object)((TypeDeclaration)node).getBody());
    }

    public void testTclSwitchProcessor001() throws TclParseException {
        String script = "switch -glob aaab { a*b - b {expr 1} a* {expr 2} default {expr 3} }";
        this.testTclSwitchProcessor(script, 3);
    }

    public void testTclSwitchProcessor002() throws TclParseException {
        String script = "switch -glob aaab {\ta*b -\tb {\t\texpr 1\t} \ta* {\t\texpr 2\t} \tdefault {\t\texpr 3}";
        this.testTclSwitchProcessor(script, 3);
    }

    public void testTclSwitchProcessor003() throws TclParseException {
        String script = "switch -exact -regexp -glob \"\" {\t[func] {puts py!}\tdefault {puts boo}";
        this.testTclSwitchProcessor(script, 2);
    }

    public void testTclSwitchProcessor004() throws TclParseException {
        String script = "switch -regexp -exact -glob -- -bu {-bu {puts boo}}";
        this.testTclSwitchProcessor(script, 1);
    }

    public void testTclSwitchProcessor005() throws TclParseException {
        String script = "switch string {set {\tpid}default {puts boo}}";
        this.testTclSwitchProcessor(script, 2);
    }

    private void testTclSwitchProcessor(String script, int alternativesNumber) throws TclParseException {
        TclSwitchCommandProcessor processor = new TclSwitchCommandProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclSwitchStatement switchExpr = (TclSwitchStatement)node;
        TclCommandProcessorTests.assertNotNull((Object)switchExpr.getString());
        TclCommandProcessorTests.assertNotNull((Object)switchExpr.getAlternatives());
        TclCommandProcessorTests.assertEquals((int)alternativesNumber, (int)switchExpr.getAlternatives().getChilds().size());
    }

    public void testTclForProcessor001() throws TclParseException {
        String script = "for {set x 0} {$x < 10} {incr x} {puts $x}";
        TclForCommandProcessor processor = new TclForCommandProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNotNull((Object)node);
        TclCommandProcessorTests.assertTrue((boolean)(node instanceof TclForStatement));
        TclForStatement forStatement = (TclForStatement)node;
        TclCommandProcessorTests.assertEquals((int)1, (int)forStatement.getChilds().size());
    }

    public void testTclForProcessor002() throws TclParseException {
        String script = "for {set x 0} $x<10";
        TclForCommandProcessor processor = new TclForCommandProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNull((Object)node);
    }

    public void testTclForProcessor003() throws TclParseException {
        String script = "for {set x 0} { $x<10 }";
        TclForCommandProcessor processor = new TclForCommandProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNull((Object)node);
    }

    public void testTclForProcessor004() throws TclParseException {
        String script = "for {set x 0} { $x<10 } { incr x }";
        TclForCommandProcessor processor = new TclForCommandProcessor();
        ASTNode node = processor.process(TclCommandProcessorTests.toCommand(script), (ITclParser)new TestTclParser(script), null);
        TclCommandProcessorTests.assertNull((Object)node);
    }

    public void testTclForeachProcessor001() throws TclParseException {
        String script = "foreach a {1 2 3 4} {set a 0}";
        this.testTclForeachProcessor(script, 1);
    }

    public void testTclForeachProcessor002() throws TclParseException {
        String script = "foreach {a b} {1 2 3 4} {a b} {1 2 3 4} pid";
        this.testTclForeachProcessor(script, 2);
    }

    private void testTclForeachProcessor(String script, int listsNumber) throws TclParseException {
    }
}

