/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.CorrectionEngine;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.internal.core.packages.TclVariableResolver;
import org.eclipse.dltk.tcl.internal.ui.text.TclGlobalVariableSourceCorrectionMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclRequirePackageCorrectionMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclRequirePackageMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclSourceCorrectionMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclSourcePackageCorrectionProcessor;
import org.eclipse.dltk.ui.text.ScriptMarkerResoltionUtils;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclRequireMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (TclSourcePackageCorrectionProcessor.isFixable(marker)) {
            IResource resource;
            String pkgName;
            int idValue = marker.getAttribute("id", 0);
            if (idValue == 0x10000001) {
                String pkgName2 = CorrectionEngine.getProblemArguments((IMarker)marker)[0];
                if (pkgName2 != null) {
                    IProject project = marker.getResource().getProject();
                    IScriptProject scriptProject = DLTKCore.create((IProject)project);
                    return new IMarkerResolution[]{new TclRequirePackageMarkerResolution(pkgName2, scriptProject)};
                }
            } else if (marker.getAttribute("id", 0) == 0x10000004) {
                String pkgName3 = CorrectionEngine.getProblemArguments((IMarker)marker)[0];
                if (pkgName3 != null) {
                    IProject project = marker.getResource().getProject();
                    IScriptProject scriptProject = DLTKCore.create((IProject)project);
                    IResource resource2 = marker.getResource();
                    if (resource2.getType() == 1) {
                        ISourceModule file = (ISourceModule)DLTKCore.create((IResource)resource2);
                        ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
                        resolutions.add(new TclSourceCorrectionMarkerResolution(pkgName3, scriptProject, file));
                        this.addGlobalVariableCorrections(pkgName3, project, scriptProject, resolutions);
                        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
                    }
                }
            } else if (idValue == 0x10000002 && (pkgName = CorrectionEngine.getProblemArguments((IMarker)marker)[0]) != null && (resource = marker.getResource()).getType() == 1) {
                ISourceModule module = (ISourceModule)DLTKCore.create((IFile)((IFile)resource));
                IProject project = resource.getProject();
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
                resolutions.add(new TclRequirePackageCorrectionMarkerResolution(pkgName, scriptProject, module));
                this.addGlobalVariableCorrections(pkgName, project, scriptProject, resolutions);
                return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
            }
        }
        return ScriptMarkerResoltionUtils.NO_RESOLUTIONS;
    }

    private void addGlobalVariableCorrections(String pkgName, IProject project, IScriptProject scriptProject, List<IMarkerResolution> resolutions) {
        String[] names = TclVariableResolver.extractVariableNames((String)pkgName);
        Map eMap = TclPackagesManager.getVariables((String)project.getName());
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (!eMap.containsKey(var)) {
                    resolutions.add(new TclGlobalVariableSourceCorrectionMarkerResolution(var, scriptProject));
                }
                ++n2;
            }
        }
    }
}

