/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.core.TclKeywordsManager;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.dltk.tcl.core.extensions.ISourceElementRequestVisitorExtension;
import org.eclipse.dltk.tcl.internal.core.TclExtensionManager;
import org.eclipse.dltk.tcl.internal.parser.OldTclParserUtils;

public class TclSourceElementRequestVisitor
extends SourceElementRequestVisitor {
    protected Stack namespacesLevel = new Stack();
    protected Stack exitStack = new Stack();
    protected IProblemReporter fReporter;
    protected ISourceElementRequestVisitorExtension[] extensions = TclExtensionManager.getDefault().getSourceElementRequestoVisitorExtensions();
    private static String[] kw = TclKeywordsManager.getKeywords();
    private static Map kwMap = new HashMap();

    static {
        int q = 0;
        while (q < kw.length) {
            kwMap.put(kw[q], Boolean.TRUE);
            ++q;
        }
    }

    public TclSourceElementRequestVisitor(ISourceElementRequestor requestor, IProblemReporter reporter) {
        super(requestor);
        this.fReporter = reporter;
    }

    protected String removeLastSegment(String s, String delimeter) {
        if (s.indexOf("::") == -1) {
            return "";
        }
        int pos = s.length() - 1;
        while (s.charAt(pos) != ':') {
            --pos;
        }
        if (pos > 1) {
            return s.substring(0, pos - 1);
        }
        return "::";
    }

    protected String getEnclosingNamespace() {
        String s = (String)this.namespacesLevel.peek();
        return s;
    }

    public ExitFromType resolveType(Declaration decl, String name, boolean onlyCurrent) {
        String type = this.removeLastSegment(name, "::");
        while (type.length() > 2 && type.endsWith("::")) {
            type = type.substring(0, type.length() - 2);
        }
        if (type.length() == 0) {
            return new ExitFromType(0, 0, false, false);
        }
        if (type.equals("::")) {
            this.fRequestor.enterModuleRoot();
            this.namespacesLevel.push("::");
            return new ExitFromType(0, decl.sourceEnd(), true, true);
        }
        boolean fqn = type.startsWith("::");
        String fullyQualified = type;
        if (!fqn) {
            String e = this.getEnclosingNamespace();
            if (e == null) {
                throw new AssertionError((Object)"there are no enclosing namespace!");
            }
            if (!e.endsWith("::")) {
                e = String.valueOf(e) + "::";
            }
            fullyQualified = String.valueOf(e) + type;
        }
        if (this.fRequestor.enterTypeAppend(type, "::")) {
            this.namespacesLevel.push(fullyQualified);
            return new ExitFromType(1, decl.sourceEnd(), false, true);
        }
        int needEnterLeave = 0;
        String[] split = null;
        String e = this.getEnclosingNamespace();
        if (e == null) {
            throw new AssertionError((Object)"there are no enclosing namespace!");
        }
        boolean entered = false;
        boolean exitFromModule = false;
        if (e.length() > 0 && !fqn) {
            entered = this.fRequestor.enterTypeAppend(e, "::");
        }
        if (fqn || !entered) {
            split = TclParseUtil.tclSplit(fullyQualified.substring(2));
            this.fRequestor.enterModuleRoot();
            exitFromModule = true;
        } else {
            if (!entered) {
                throw new AssertionError((Object)"can't enter to enclosing namespace!");
            }
            ++needEnterLeave;
            split = TclParseUtil.tclSplit(type);
        }
        int i = 0;
        while (i < split.length) {
            if (split[i].length() > 0) {
                ++needEnterLeave;
                if (!this.fRequestor.enterTypeAppend(split[i], "::")) {
                    ISourceElementRequestor.TypeInfo ti = new ISourceElementRequestor.TypeInfo();
                    ti.modifiers = decl instanceof TypeDeclaration ? this.getModifiers(decl) : 4096;
                    ti.name = split[i];
                    ti.nameSourceStart = decl.getNameStart();
                    ti.nameSourceEnd = decl.getNameEnd() - 1;
                    ti.declarationStart = decl.sourceStart();
                    if (decl instanceof TypeDeclaration) {
                        ti.superclasses = this.processSuperClasses((TypeDeclaration)decl);
                    }
                    this.fRequestor.enterType(ti);
                }
            }
            ++i;
        }
        this.namespacesLevel.push(fullyQualified);
        return new ExitFromType(needEnterLeave, decl.sourceEnd(), exitFromModule, true, true);
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        this.fNodes.push(s);
        ISourceElementRequestor.TypeInfo info = new ISourceElementRequestor.TypeInfo();
        info.modifiers = this.getModifiers((Declaration)s);
        String fullName = s.getName();
        String[] split = TclParseUtil.tclSplit(fullName);
        info.name = split.length != 0 ? split[split.length - 1] : "";
        info.nameSourceStart = s.getNameStart();
        info.nameSourceEnd = s.getNameEnd();
        info.declarationStart = s.sourceStart();
        info.superclasses = this.processSuperClasses(s);
        info.modifiers = this.getModifiers((Declaration)s);
        ExitFromType exit = this.resolveType((Declaration)s, String.valueOf(fullName) + "::dummy", true);
        this.exitStack.push(exit);
        this.fInClass = true;
        return true;
    }

    protected int getModifiers(Declaration s) {
        int flags = 0;
        flags = s.getModifiers();
        int i = 0;
        while (i < this.extensions.length) {
            flags |= this.extensions[i].getModifiers(s);
            ++i;
        }
        return flags;
    }

    public boolean endvisit(TypeDeclaration typeDeclaration) throws Exception {
        ExitFromType exit = (ExitFromType)this.exitStack.pop();
        exit.go();
        this.fInClass = false;
        this.onEndVisitClass(typeDeclaration);
        this.fNodes.pop();
        return true;
    }

    public boolean visit(Statement statement) throws Exception {
        this.fNodes.push(statement);
        if (statement instanceof TclPackageDeclaration) {
            this.processPackage(statement);
            this.fNodes.pop();
            return false;
        }
        if (statement instanceof TclStatement) {
            this.fNodes.pop();
            this.processReferences((TclStatement)statement);
            return false;
        }
        if (statement instanceof FieldDeclaration) {
            this.processField(statement);
            return false;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].visit(statement, this)) {
                return true;
            }
            ++i;
        }
        return true;
    }

    private void processReferences(TclStatement statement) {
        Expression commandId = statement.getAt(0);
        if (commandId != null && commandId instanceof SimpleReference) {
            String name = ((SimpleReference)commandId).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if (!kwMap.containsKey(name)) {
                int argCount = statement.getCount() - 1;
                if (name.length() > 0 && name.charAt(0) != '$') {
                    this.fRequestor.acceptMethodReference(name.toCharArray(), argCount, commandId.sourceStart(), commandId.sourceEnd());
                }
            }
        }
        int j = 1;
        while (j < statement.getCount()) {
            SimpleReference ref;
            String name;
            List exprs;
            Expression st = statement.getAt(j);
            if (st instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)st;
                exprs = expr.parseExpression();
                int i = 0;
                while (i < exprs.size()) {
                    if (exprs.get(i) instanceof TclStatement) {
                        this.processReferences((TclStatement)((Object)exprs.get(i)));
                    } else if (exprs.get(i) instanceof TclPackageDeclaration) {
                        this.processPackage((Statement)exprs.get(i));
                    }
                    ++i;
                }
            } else if (st instanceof TclAdvancedExecuteExpression) {
                TclAdvancedExecuteExpression expr = (TclAdvancedExecuteExpression)st;
                exprs = expr.getStatements();
                int i = 0;
                while (i < exprs.size()) {
                    if (exprs.get(i) instanceof TclStatement) {
                        this.processReferences((TclStatement)((Object)exprs.get(i)));
                    } else if (exprs.get(i) instanceof TclPackageDeclaration) {
                        this.processPackage((Statement)exprs.get(i));
                    }
                    ++i;
                }
            } else if (st instanceof StringLiteral) {
                int pos = 0;
                StringLiteral literal = (StringLiteral)st;
                String value = literal.getValue();
                pos = value.indexOf("$");
                while (pos != -1) {
                    SimpleReference ref2 = OldTclParserUtils.findVariableFromString(literal, pos);
                    if (ref2 != null) {
                        this.fRequestor.acceptFieldReference(ref2.getName().substring(1).toCharArray(), ref2.sourceStart());
                        pos += ref2.getName().length();
                    }
                    pos = value.indexOf("$", pos + 1);
                }
            } else if (st instanceof SimpleReference && (name = (ref = (SimpleReference)st).getName()).startsWith("$")) {
                this.fRequestor.acceptFieldReference(ref.getName().substring(1).toCharArray(), ref.sourceStart());
            }
            ++j;
        }
    }

    private void processPackage(Statement statement) {
        TclPackageDeclaration pack = (TclPackageDeclaration)statement;
        ASTNode version = pack.getVersion();
        if (pack.getStyle() == 0) {
            if (version != null && version instanceof SimpleReference) {
                this.fRequestor.acceptPackage(pack.getNameStart(), pack.getNameEnd(), (String.valueOf(pack.getName()) + " (" + ((SimpleReference)version).getName() + ")").toCharArray());
            } else {
                this.fRequestor.acceptPackage(pack.getNameStart(), pack.getNameEnd(), pack.getName().toCharArray());
            }
        } else if (pack.getStyle() == 1) {
            if (version != null && version instanceof SimpleReference) {
                this.fRequestor.acceptPackage(pack.getNameStart(), pack.getNameEnd(), (String.valueOf(pack.getName()) + " (" + ((SimpleReference)version).getName() + ")*").toCharArray());
            } else {
                this.fRequestor.acceptPackage(pack.getNameStart(), pack.getNameEnd(), (String.valueOf(pack.getName()) + "*").toCharArray());
            }
        }
    }

    protected boolean processField(Statement statement) {
        FieldDeclaration decl = (FieldDeclaration)statement;
        ISourceElementRequestor.FieldInfo fi = new ISourceElementRequestor.FieldInfo();
        fi.nameSourceStart = decl.getNameStart();
        fi.nameSourceEnd = decl.getNameEnd() - 1;
        fi.declarationStart = decl.sourceStart();
        fi.modifiers = this.getModifiers((Declaration)decl);
        boolean needExit = false;
        String arrayName = null;
        String arrayIndex = null;
        String name = decl.getName();
        if (TclParseUtil.isArrayVariable(name)) {
            arrayName = TclParseUtil.extractArrayName(name);
            arrayIndex = TclParseUtil.extractArrayIndex(name);
        }
        if (arrayName != null) {
            name = arrayName;
        }
        fi.name = name;
        String fullName = TclParseUtil.escapeName(name);
        ExitFromType exit = null;
        int i = 0;
        while (i < this.extensions.length) {
            exit = this.extensions[i].processField(decl, this);
            if (exit != null) {
                // empty if block
            }
            ++i;
        }
        if (exit == null) {
            exit = this.resolveType((Declaration)decl, fullName, false);
        }
        needExit = this.fRequestor.enterFieldCheckDuplicates(fi);
        int end = decl.sourceEnd();
        if (needExit) {
            if (arrayName != null) {
                ISourceElementRequestor.FieldInfo fiIndex = new ISourceElementRequestor.FieldInfo();
                fiIndex.name = String.valueOf(arrayName) + "(" + arrayIndex + ")";
                fiIndex.nameSourceStart = decl.getNameStart();
                fiIndex.nameSourceEnd = decl.getNameEnd() - 1;
                fiIndex.declarationStart = decl.sourceStart();
                fiIndex.modifiers = 0x2719 | this.getModifiers((Declaration)decl);
                if (this.fRequestor.enterFieldCheckDuplicates(fiIndex)) {
                    this.fRequestor.exitField(end);
                }
            }
            this.fRequestor.exitField(end);
        }
        exit.go();
        return false;
    }

    public boolean visit(ModuleDeclaration declaration) throws Exception {
        this.namespacesLevel.push("::");
        return super.visit(declaration);
    }

    protected ExitFromType getExitExtended(MethodDeclaration method) {
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].extendedExitRequired(method, this)) {
                return this.extensions[i].getExitExtended(method, this);
            }
            ++i;
        }
        return null;
    }

    protected boolean extendedExitRequired(MethodDeclaration method) {
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].extendedExitRequired(method, this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        this.fInMethod = true;
        this.fCurrentMethod = method;
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].skipMethod(method, this)) {
                return true;
            }
            ++i;
        }
        String[] parameter = null;
        String[] parameterInitializers = null;
        List arguments = method.getArguments();
        if (arguments != null) {
            parameter = new String[arguments.size()];
            parameterInitializers = new String[arguments.size()];
            int a = 0;
            while (a < arguments.size()) {
                Object node = arguments.get(a);
                parameterInitializers[a] = null;
                if (node instanceof Argument) {
                    Argument ref = (Argument)node;
                    parameter[a] = ref.getName();
                    Statement e = (Statement)ref.getInitialization();
                    if (e != null) {
                        String name;
                        if (e instanceof SimpleReference) {
                            parameterInitializers[a] = ((SimpleReference)e).getName();
                        } else if (e instanceof TclBlockExpression) {
                            name = ((TclBlockExpression)e).getBlock();
                            parameterInitializers[a] = TclParseUtil.nameFromBlock(name, '{', '}');
                        } else if (e instanceof StringLiteral) {
                            name = ((StringLiteral)e).getValue();
                            parameterInitializers[a] = TclParseUtil.nameFromBlock(name, '\"', '\"');
                        } else if (e instanceof TclExecuteExpression) {
                            parameterInitializers[a] = name = ((TclExecuteExpression)e).getExpression();
                        }
                    }
                } else if (node instanceof String) {
                    parameter[a] = (String)node;
                }
                ++a;
            }
        }
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        String sName = method.getName();
        String fullName = sName = TclParseUtil.escapeName(sName);
        if (fullName.indexOf("::") != -1) {
            String[] split = TclParseUtil.tclSplit(fullName);
            sName = split[split.length - 1];
        }
        mi.parameterNames = parameter;
        mi.parameterInitializers = parameterInitializers;
        mi.name = sName;
        mi.modifiers = this.getModifiers((Declaration)method);
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        ExitFromType exit = null;
        exit = this.extendedExitRequired(method) ? this.getExitExtended(method) : this.resolveType((Declaration)method, fullName, false);
        this.fRequestor.enterMethodRemoveSame(mi);
        this.exitStack.push(exit);
        return true;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].skipMethod(method, this)) {
                this.fNodes.pop();
                return true;
            }
            ++i;
        }
        super.endvisit(method);
        ExitFromType exit = (ExitFromType)this.exitStack.pop();
        exit.go();
        return true;
    }

    public ISourceElementRequestor getRequestor() {
        return this.fRequestor;
    }

    public class ExitFromType {
        private int level;
        private int end;
        private boolean exitFromModule;
        private boolean pop;
        public boolean created = false;

        public ExitFromType(int level, int declEnd, boolean mod, boolean pop) {
            this.level = level;
            this.end = declEnd;
            this.exitFromModule = mod;
            this.pop = pop;
        }

        public ExitFromType(int level, int declEnd, boolean mod, boolean pop, boolean created) {
            this(level, declEnd, mod, pop);
            this.created = created;
        }

        public void go() {
            int i = 0;
            while (i < this.level) {
                TclSourceElementRequestVisitor.this.fRequestor.exitType(this.end);
                ++i;
            }
            if (this.exitFromModule) {
                TclSourceElementRequestVisitor.this.fRequestor.exitModuleRoot();
            }
            if (this.pop) {
                TclSourceElementRequestVisitor.this.namespacesLevel.pop();
            }
        }
    }
}

