/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DLTKUiBridge
extends AbstractContextUiBridge {
    private Field scriptOutlineField = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DLTKUiBridge() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.scriptOutlineField = clazz.getDeclaredField("fOutlineViewer");
            this.scriptOutlineField.setAccessible(true);
        }
        catch (Exception e) {
            MylynStatusHandler.fail(e, "could not get install Mylyn on Outline viewer", true);
        }
    }

    public void open(IInteractionElement node) {
        IModelElement modelElement = DLTKCore.create((String)node.getHandleIdentifier());
        if (modelElement == null || !modelElement.exists()) {
            return;
        }
        try {
            IEditorPart part = EditorUtility.openInEditor((Object)modelElement);
            EditorUtility.revealInEditor((IEditorPart)part, (IModelElement)modelElement);
        }
        catch (Throwable t) {
            MylynStatusHandler.fail(t, "Could not open editor for: " + node, true);
        }
    }

    public void restoreEditor(IInteractionElement document) {
        IResource resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(document, false);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && resource instanceof IFile && resource.exists()) {
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)false);
            }
            catch (PartInitException e) {
                MylynStatusHandler.fail(e, "failed to open editor for: " + resource, false);
            }
        }
    }

    public void close(IInteractionElement node) {
        block8: {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) break block8;
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof ScriptEditor) {
                        Object adapter;
                        ScriptEditor editor = (ScriptEditor)part;
                        IEditorInput iEditorInput = editor.getEditorInput();
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.dltk.core.IModelElement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((adapter = iEditorInput.getAdapter((Class)clazz)) instanceof IModelElement && node.getHandleIdentifier().equals(((IModelElement)adapter).getHandleIdentifier())) {
                            editor.close(true);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                MylynStatusHandler.fail(t, "Could not auto close editor.", false);
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof ScriptEditor;
    }

    public IInteractionElement getElement(IEditorInput input) {
        Object adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = input.getAdapter((Class)clazz)) instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)adapter;
            String handle = ContextCorePlugin.getDefault().getStructureBridge((Object)modelElement).getHandleIdentifier((Object)modelElement);
            return ContextCorePlugin.getContextManager().getElement(handle);
        }
        return null;
    }

    public List getContentOutlineViewers(IEditorPart editorPart) {
        ScriptOutlinePage page;
        Object out;
        if (editorPart == null || this.scriptOutlineField == null) {
            return null;
        }
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((out = editorPart.getAdapter((Class)clazz)) instanceof ScriptOutlinePage && (page = (ScriptOutlinePage)out) != null && page.getControl() != null) {
            try {
                viewers.add((TreeViewer)this.scriptOutlineField.get(page));
            }
            catch (Exception e) {
                MylynStatusHandler.log(e, "could not get outline viewer");
            }
        }
        return viewers;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        if (editor instanceof ScriptEditor) {
            TextSelection textSelection = selection;
            try {
                Object element;
                if (selection != null) {
                    return SelectionConverter.resolveEnclosingElement((IEditorPart)((ScriptEditor)editor), (ITextSelection)textSelection);
                }
                IEditorInput iEditorInput = ((ScriptEditor)editor).getEditorInput();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = iEditorInput.getAdapter((Class)clazz)) instanceof IModelElement) {
                    return element;
                }
            }
            catch (ModelException modelException) {}
        }
        return null;
    }

    public String getContentType() {
        return "script";
    }
}

