/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

public class DLTKStructureBridge
extends AbstractContextStructureBridge
implements IExecutableExtension {
    public String contentType = "";
    public static final String ID_PLUGIN = "org.eclipse.dltk.mylyn.ui";
    public List providers = new ArrayList();
    static /* synthetic */ Class class$0;

    public String getContentType() {
        return this.contentType;
    }

    public Object getAdaptedParent(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return DLTKCore.create((IResource)file.getParent());
        }
        return super.getAdaptedParent(object);
    }

    public String getParentHandle(String handle) {
        IModelElement modelElement = (IModelElement)this.getObjectForHandle(handle);
        if (modelElement != null && modelElement.getParent() != null) {
            return this.getHandleIdentifier(modelElement.getParent());
        }
        return null;
    }

    public List getChildHandles(String handle) {
        IModelElement element;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof IModelElement && (element = (IModelElement)object) instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                List resourceChildren;
                IModelElement[] children = parent.getChildren();
                ArrayList<String> childHandles = new ArrayList<String>();
                int i = 0;
                while (i < children.length) {
                    String childHandle = this.getHandleIdentifier(children[i]);
                    if (childHandle != null) {
                        childHandles.add(childHandle);
                    }
                    ++i;
                }
                AbstractContextStructureBridge parentBridge = ContextCorePlugin.getDefault().getStructureBridge(this.parentContentType);
                if (parentBridge != null && parentBridge instanceof ResourceStructureBridge && element.getElementType() < 7 && !(resourceChildren = parentBridge.getChildHandles(handle)).isEmpty()) {
                    childHandles.addAll(resourceChildren);
                }
                return childHandles;
            }
            catch (ModelException modelException) {
            }
            catch (Exception e) {
                MylynStatusHandler.fail(e, "could not get child", false);
            }
        }
        return new ArrayList();
    }

    public Object getObjectForHandle(String handle) {
        try {
            return DLTKCore.create((String)handle);
        }
        catch (Throwable throwable) {
            MylynStatusHandler.log("Could not create script element for handle: " + handle, this);
            return null;
        }
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof IModelElement) {
            return ((IModelElement)object).getHandleIdentifier();
        }
        if (object instanceof IAdaptable) {
            Object adapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = iAdaptable.getAdapter((Class)clazz)) instanceof IModelElement) {
                return ((IModelElement)adapter).getHandleIdentifier();
            }
        }
        return null;
    }

    public boolean canBeLandmark(String handle) {
        IModelElement element = (IModelElement)this.getObjectForHandle(handle);
        return (element instanceof IMember || element instanceof IType || element instanceof ISourceModule) && element.exists();
    }

    public boolean acceptsObject(Object object) {
        if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = iResource.getAdapter((Class)clazz);
            return adapter instanceof IModelElement;
        }
        boolean accepts = object instanceof IModelElement || object instanceof ProjectFragment || object instanceof BuildPathContainer.RequiredProjectWrapper || object instanceof IProjectFragment || object instanceof WorkingSet;
        return accepts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object object) {
        if (object instanceof BuildPathContainer.RequiredProjectWrapper) {
            return true;
        }
        if (!(object instanceof WorkingSet)) return true;
        try {
            WorkingSet workingSet = (WorkingSet)object;
            IAdaptable[] elements = workingSet.getElements();
            int i = 0;
            while (true) {
                if (i >= elements.length) {
                    return true;
                }
                IAdaptable adaptable = elements[i];
                IInteractionElement element = ContextCorePlugin.getContextManager().getElement(this.getHandleIdentifier(adaptable));
                if (element.getInterest().isInteresting()) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDocument(String handle) {
        IModelElement element = (IModelElement)this.getObjectForHandle(handle);
        return element instanceof ISourceModule;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        IMarker marker;
        if (object instanceof ConcreteMarker) {
            marker = ((ConcreteMarker)object).getMarker();
        } else if (object instanceof IMarker) {
            marker = (IMarker)object;
        } else {
            return null;
        }
        int charStart = marker.getAttribute("charStart", 0);
        try {
            IFile file;
            String ext;
            ISourceModule compilationUnit = null;
            IResource resource = marker.getResource();
            if (resource instanceof IFile && (ext = (file = (IFile)resource).getFileExtension()).equals(this.contentType)) {
                compilationUnit = DLTKCore.createSourceModuleFrom((IFile)file);
            }
            if (compilationUnit != null) {
                IModelElement javaElement = compilationUnit.getElementAt(charStart);
                if (javaElement != null) {
                    return javaElement.getHandleIdentifier();
                }
                return null;
            }
            return null;
        }
        catch (ModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)ex, (String)"error", (String)"could not find script element");
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not find element for: " + marker, t));
            return null;
        }
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public List getRelationshipProviders() {
        return this.providers;
    }

    public boolean containsProblem(IInteractionElement node) {
        try {
            IModelElement element = (IModelElement)this.getObjectForHandle(node.getHandleIdentifier());
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                }
                case 5: 
                case 6: 
                case 10: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                }
                case 7: 
                case 8: 
                case 9: {
                    ISourceModule cu = (ISourceModule)element.getAncestor(5);
                    if (cu != null) {
                        return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return false;
        }
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length) {
                int priority;
                IMarker curr = markers[i];
                if (sourceElement == null && (priority = curr.getAttribute("severity", -1)) == 2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getLabel(Object arg0) {
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.contentType = config.getAttribute("extension");
    }
}

