/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.JsPreferenceInterpreter;
import org.eclipse.dltk.javascript.scriptdoc.DefaultCodeFormatterConstants;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public final class JavaIndenter {
    private final IDocument fDocument;
    private int fIndent;
    private int fAlign;
    private int fPosition;
    private int fPreviousPos;
    private int fToken;
    private int fLine;
    private final JavaHeuristicScanner fScanner;
    private final CorePrefs fPrefs;

    public JavaIndenter(IDocument document, JavaHeuristicScanner scanner, IScriptProject project) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)scanner);
        this.fDocument = document;
        this.fScanner = scanner;
        this.fPrefs = new CorePrefs(project);
    }

    public StringBuffer getReferenceIndentation(int offset) {
        return this.getReferenceIndentation(offset, false);
    }

    private StringBuffer getReferenceIndentation(int offset, boolean assumeOpeningBrace) {
        int unit = assumeOpeningBrace ? this.findReferencePosition(offset, 1) : this.findReferencePosition(offset, this.peekChar(offset));
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public StringBuffer computeIndentation(int offset) {
        return this.computeIndentation(offset, false);
    }

    public StringBuffer computeIndentation(int offset, boolean assumeOpeningBrace) {
        StringBuffer reference = this.getReferenceIndentation(offset, assumeOpeningBrace);
        if (this.fAlign != -1) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(this.fAlign);
                int lineOffset = line.getOffset();
                return this.createIndent(lineOffset, this.fAlign, false);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (reference == null) {
            return null;
        }
        return this.createReusingIndent(reference, this.fIndent);
    }

    private int computeVisualLength(CharSequence indent) {
        int tabSize = this.fPrefs.prefTabSize;
        int length = 0;
        int i = 0;
        while (i < indent.length()) {
            char ch = indent.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    int reminder = length % tabSize;
                    length += tabSize - reminder;
                    break;
                }
                case ' ': {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }

    private StringBuffer stripExceedingChars(StringBuffer reference, int indentLength) {
        int tabSize = this.fPrefs.prefTabSize;
        int measured = 0;
        int chars = reference.length();
        int i = 0;
        while (measured < indentLength && i < chars) {
            char ch = reference.charAt(i);
            switch (ch) {
                case '\t': {
                    if (tabSize <= 0) break;
                    int reminder = measured % tabSize;
                    measured += tabSize - reminder;
                    break;
                }
                case ' ': {
                    ++measured;
                }
            }
            ++i;
        }
        int deleteFrom = measured > indentLength ? i - 1 : i;
        return reference.delete(deleteFrom, chars);
    }

    private StringBuffer getLeadingWhitespace(int offset) {
        StringBuffer indent = new StringBuffer();
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            ITypedRegion partition = TextUtilities.getPartition((IDocument)this.fDocument, (String)"__javascript_partitioning", (int)lineOffset, (boolean)true);
            String type = partition.getType();
            while ((type.equals("__javascript_doc") || type.equals("__javascript_comment")) && lineOffset > 0) {
                IRegion tmpLine = this.fDocument.getLineInformationOfOffset(lineOffset - 1);
                partition = TextUtilities.getPartition((IDocument)this.fDocument, (String)"__javascript_partitioning", (int)tmpLine.getOffset(), (boolean)false);
                type = partition.getType();
                if (!type.equals("__javascript_doc") && !type.equals("__javascript_comment")) continue;
                line = tmpLine;
                lineOffset = line.getOffset();
            }
            int nonWS = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            indent.append(this.fDocument.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }

    private StringBuffer createIndent(int start, int indent, boolean convertSpaceRunsToTabs) {
        boolean convertTabs = this.fPrefs.prefUseTabs && convertSpaceRunsToTabs;
        int tabLen = this.fPrefs.prefTabSize;
        StringBuffer ret = new StringBuffer();
        try {
            int spaces = 0;
            while (start < indent) {
                char ch = this.fDocument.getChar(start);
                if (ch == '\t') {
                    ret.append('\t');
                    spaces = 0;
                } else if (convertTabs) {
                    if (++spaces == tabLen) {
                        ret.append('\t');
                        spaces = 0;
                    }
                } else {
                    ret.append(' ');
                }
                ++start;
            }
            while (spaces-- > 0) {
                ret.append(' ');
            }
        }
        catch (BadLocationException badLocationException) {}
        return ret;
    }

    private StringBuffer createReusingIndent(StringBuffer buffer, int additional) {
        int spaces;
        int tabs;
        int refLength = this.computeVisualLength(buffer);
        int addLength = this.fPrefs.prefIndentationSize * additional;
        int totalLength = Math.max(0, refLength + addLength);
        int minLength = Math.min(totalLength, refLength);
        int tabSize = this.fPrefs.prefTabSize;
        int maxCopyLength = tabSize > 0 ? minLength - minLength % tabSize : minLength;
        this.stripExceedingChars(buffer, maxCopyLength);
        int missing = totalLength - maxCopyLength;
        if (" ".equals(this.fPrefs.prefTabChar)) {
            tabs = 0;
            spaces = missing;
        } else if ("\t".equals(this.fPrefs.prefTabChar)) {
            tabs = tabSize > 0 ? missing / tabSize : 0;
            spaces = tabSize > 0 ? missing % tabSize : missing;
        } else if ("mixed".equals(this.fPrefs.prefTabChar)) {
            tabs = tabSize > 0 ? missing / tabSize : 0;
            spaces = tabSize > 0 ? missing % tabSize : missing;
        } else {
            tabs = 0;
            spaces = missing;
        }
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer;
    }

    public int findReferencePosition(int offset) {
        return this.findReferencePosition(offset, this.peekChar(offset));
    }

    private int peekChar(int offset) {
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineOffset = line.getOffset();
                int next = this.fScanner.nextToken(offset, lineOffset + line.getLength());
                return next;
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public int findReferencePosition(int offset, int nextToken) {
        boolean danglingElse = false;
        boolean unindent = false;
        boolean indent = false;
        boolean matchBrace = false;
        boolean matchParen = false;
        boolean matchCase = false;
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineOffset = line.getOffset();
                int prevPos = Math.max(offset - 1, 0);
                boolean isFirstTokenOnLine = this.fDocument.get(lineOffset, prevPos + 1 - lineOffset).trim().length() == 0;
                int prevToken = this.fScanner.previousToken(prevPos, -2);
                boolean bracelessBlockStart = this.fScanner.isBracelessBlockStart(prevPos, -2);
                switch (nextToken) {
                    case 1014: {
                        danglingElse = true;
                        break;
                    }
                    case 1013: 
                    case 1024: {
                        if (isFirstTokenOnLine) {
                            matchCase = true;
                        }
                        break;
                    }
                    case 1: {
                        if (bracelessBlockStart && !this.fPrefs.prefIndentBracesForBlocks) {
                            unindent = true;
                            break;
                        }
                        if (!(prevToken != 9 && prevToken != 12 && prevToken != 4 || this.fPrefs.prefIndentBracesForArrays)) {
                            unindent = true;
                            break;
                        }
                        if (!bracelessBlockStart && this.fPrefs.prefIndentBracesForMethods) {
                            indent = true;
                        }
                        break;
                    }
                    case 2: {
                        if (isFirstTokenOnLine) {
                            matchBrace = true;
                        }
                        break;
                    }
                    case 6: {
                        if (!isFirstTokenOnLine) break;
                        matchParen = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            danglingElse = false;
        }
        int ref = this.findReferencePosition(offset, danglingElse, matchBrace, matchParen, matchCase);
        if (unindent) {
            --this.fIndent;
        }
        if (indent) {
            ++this.fIndent;
        }
        return ref;
    }

    public int findReferencePosition(int offset, boolean danglingElse, boolean matchBrace, boolean matchParen, boolean matchCase) {
        this.fIndent = 0;
        this.fAlign = -1;
        this.fPosition = offset;
        if (matchBrace) {
            if (this.skipScope(1, 2)) {
                try {
                    int lineOffset = this.fDocument.getLineOffset(this.fLine);
                    if (lineOffset <= this.fPosition && this.fDocument.get(lineOffset, this.fPosition - lineOffset).trim().length() == 0) {
                        return this.fPosition;
                    }
                }
                catch (BadLocationException badLocationException) {}
                int pos = this.skipToStatementStart(true, true);
                this.fIndent = 0;
                return pos;
            }
            int pos = this.findReferencePosition(offset, danglingElse, false, matchParen, matchCase);
            --this.fIndent;
            return pos;
        }
        if (matchParen) {
            if (this.skipScope(5, 6)) {
                return this.fPosition;
            }
            int pos = this.findReferencePosition(offset, danglingElse, matchBrace, false, matchCase);
            --this.fIndent;
            return pos;
        }
        if (matchCase) {
            return this.matchCaseAlignment();
        }
        this.nextToken();
        switch (this.fToken) {
            case 2: 
            case 14: {
                int pos = this.fPosition;
                if (!this.skipScope()) {
                    this.fPosition = pos;
                }
            }
            case 7: {
                return this.skipToStatementStart(danglingElse, false);
            }
            case 1: 
            case 3: 
            case 5: {
                return this.handleScopeIntroduction(offset + 1);
            }
            case -1: {
                return -1;
            }
            case 12: {
                this.fIndent = this.fPrefs.prefAssignmentIndent;
                return this.fPosition;
            }
            case 9: {
                this.fIndent = this.fPrefs.prefCaseBlockIndent;
                return this.fPosition;
            }
            case 10: {
                if (this.fPrefs.prefTernaryDeepAlign) {
                    this.setFirstElementAlignment(this.fPosition, offset + 1);
                    return this.fPosition;
                }
                this.fIndent = this.fPrefs.prefTernaryIndent;
                return this.fPosition;
            }
            case 1010: 
            case 1014: 
            case 1017: {
                this.fIndent = this.fPrefs.prefSimpleIndent;
                return this.fPosition;
            }
            case 1012: {
                return this.skipToStatementStart(danglingElse, false);
            }
            case 6: {
                int line = this.fLine;
                if (this.skipScope(5, 6)) {
                    int scope = this.fPosition;
                    this.nextToken();
                    if (this.fToken == 109 || this.fToken == 1017 || this.fToken == 1011) {
                        this.fIndent = this.fPrefs.prefSimpleIndent;
                        return this.fPosition;
                    }
                    this.fPosition = scope;
                    if (this.looksLikeMethodDecl()) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                    if (this.fToken == 1016) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                    this.fPosition = scope;
                    if (this.looksLikeAnonymousTypeDecl()) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                }
                this.fPosition = offset;
                this.fLine = line;
            }
        }
        return this.skipToPreviousListItemOrListStart();
    }

    private int skipToStatementStart(boolean danglingElse, boolean isInBlock) {
        int mayBeMethodBody = 0;
        boolean isTypeBody = false;
        boolean skipFirstSEMICOLON = true;
        while (true) {
            this.nextToken();
            while (skipFirstSEMICOLON && this.fToken == 7) {
                this.nextToken();
            }
            skipFirstSEMICOLON = false;
            if (isInBlock) {
                switch (this.fToken) {
                    case 109: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1014: 
                    case 1016: 
                    case 1017: 
                    case 1021: {
                        return this.fPosition;
                    }
                    case 1019: {
                        mayBeMethodBody = 2;
                        break;
                    }
                    case 1022: {
                        if (mayBeMethodBody == 2) break;
                        return this.fPosition;
                    }
                    case 1026: 
                    case 1027: 
                    case 1028: {
                        isTypeBody = true;
                        break;
                    }
                    case 1020: {
                        this.fIndent = this.fPrefs.prefCaseIndent;
                        return this.fPosition;
                    }
                }
            }
            switch (this.fToken) {
                case -1: 
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    if (isInBlock) {
                        this.fIndent = this.getBlockIndent(mayBeMethodBody == 2, isTypeBody);
                    }
                    return this.fPreviousPos;
                }
                case 9: {
                    int pos = this.fPreviousPos;
                    if (this.isConditional()) break;
                    return pos;
                }
                case 2: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope() && this.looksLikeArrayInitializerIntro()) break;
                    if (isInBlock) {
                        this.fIndent = this.getBlockIndent(mayBeMethodBody == 2, isTypeBody);
                    }
                    return pos;
                }
                case 6: {
                    if (isInBlock) {
                        mayBeMethodBody = 1;
                    }
                }
                case 4: 
                case 14: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope()) break;
                    return pos;
                }
                case 109: {
                    if (!danglingElse) break;
                    return this.fPosition;
                }
                case 1014: {
                    int pos = this.fPosition;
                    if (this.skipNextIF()) break;
                    return pos;
                }
                case 1010: {
                    return this.fPosition;
                }
                case 1017: {
                    int pos = this.fPosition;
                    if (this.hasMatchingDo()) break;
                    this.fPosition = pos;
                    break;
                }
                case 2000: {
                    if (mayBeMethodBody != 1) break;
                    mayBeMethodBody = 2;
                }
            }
        }
    }

    private int getBlockIndent(boolean isMethodBody, boolean isTypeBody) {
        if (isTypeBody) {
            return this.fPrefs.prefTypeIndent + (this.fPrefs.prefIndentBracesForTypes ? 1 : 0);
        }
        if (isMethodBody) {
            return this.fPrefs.prefMethodBodyIndent + (this.fPrefs.prefIndentBracesForMethods ? 1 : 0);
        }
        return this.fIndent;
    }

    private boolean isConditional() {
        boolean identifierFound = false;
        block5: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2000: {
                    if (identifierFound) {
                        return false;
                    }
                    identifierFound = true;
                    continue block5;
                }
                case 8: {
                    identifierFound = false;
                    continue block5;
                }
                case 1013: {
                    return false;
                }
            }
            break;
        }
        return true;
    }

    private int matchCaseAlignment() {
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case -1: 
                case 3: 
                case 5: {
                    return this.fPosition;
                }
                case 1: {
                    this.fIndent = this.fPrefs.prefCaseIndent;
                    return this.fPosition;
                }
                case 1013: 
                case 1024: {
                    this.fIndent = 0;
                    return this.fPosition;
                }
                case 2: 
                case 4: 
                case 6: 
                case 14: {
                    this.skipScope();
                    continue block6;
                }
            }
        }
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this.fLine;
        int startPosition = this.fPosition;
        block9: while (true) {
            this.nextToken();
            if (this.fLine < startLine) {
                try {
                    int lineOffset = this.fDocument.getLineOffset(startLine);
                    int bound = Math.min(this.fDocument.getLength(), startPosition + 1);
                    this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, bound);
                }
                catch (BadLocationException badLocationException) {}
                return startPosition;
            }
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: 
                case 14: {
                    this.skipScope();
                    continue block9;
                }
                case 1: 
                case 3: 
                case 5: {
                    return this.handleScopeIntroduction(startPosition + 1);
                }
                case 7: {
                    return this.fPosition;
                }
                case 10: {
                    if (this.fPrefs.prefTernaryDeepAlign) {
                        this.setFirstElementAlignment(this.fPosition - 1, this.fPosition + 1);
                        return this.fPosition;
                    }
                    this.fIndent = this.fPrefs.prefTernaryIndent;
                    return this.fPosition;
                }
                case -1: {
                    return 0;
                }
            }
        }
    }

    private boolean skipScope() {
        switch (this.fToken) {
            case 6: {
                return this.skipScope(5, 6);
            }
            case 4: {
                return this.skipScope(3, 4);
            }
            case 2: {
                return this.skipScope(1, 2);
            }
            case 14: {
                if (!this.fPrefs.prefHasGenerics) {
                    return false;
                }
                int storedPosition = this.fPosition;
                int storedToken = this.fToken;
                int storedLine = this.fLine;
                int storedPreviousPos = this.fPreviousPos;
                this.nextToken();
                switch (this.fToken) {
                    case 2000: {
                        if (!JavaHeuristicScanner.isGenericStarter(this.getTokenContent())) break;
                    }
                    case 10: 
                    case 14: {
                        if (!this.skipScope(13, 14)) break;
                        return true;
                    }
                }
                this.fPosition = storedPosition;
                this.fToken = storedToken;
                this.fLine = storedLine;
                this.fPreviousPos = storedPreviousPos;
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private CharSequence getTokenContent() {
        return new DocumentCharacterIterator(this.fDocument, this.fPosition, this.fPreviousPos);
    }

    private int handleScopeIntroduction(int bound) {
        switch (this.fToken) {
            case 5: {
                int pos = this.fPosition;
                if (this.looksLikeMethodDecl()) {
                    if (this.fPrefs.prefMethodDeclDeepIndent) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.fPrefs.prefMethodDeclIndent;
                    return pos;
                }
                this.fPosition = pos;
                if (this.looksLikeMethodCall()) {
                    if (this.fPrefs.prefMethodCallDeepIndent) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.fPrefs.prefMethodCallIndent;
                    return pos;
                }
                if (this.fPrefs.prefParenthesisDeepIndent) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.fPrefs.prefParenthesisIndent;
                return pos;
            }
            case 1: {
                int pos = this.fPosition;
                if (this.looksLikeArrayInitializerIntro()) {
                    if (this.fPrefs.prefArrayDeepIndent) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.fPrefs.prefArrayIndent;
                } else {
                    this.fIndent = this.fPrefs.prefBlockIndent;
                }
                if (this.looksLikeArrayInitializerIntro() && !this.fPrefs.prefIndentBracesForArrays || !this.fPrefs.prefIndentBracesForBlocks) {
                    this.fPosition = pos;
                    return this.skipToStatementStart(true, true);
                }
                return pos;
            }
            case 3: {
                int pos = this.fPosition;
                if (this.fPrefs.prefArrayDimensionsDeepIndent) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.fPrefs.prefBracketIndent;
                return pos;
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private int setFirstElementAlignment(int scopeIntroducerOffset, int bound) {
        int firstPossible = scopeIntroducerOffset + 1;
        this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(firstPossible, bound);
        if (this.fAlign == -1) {
            this.fAlign = firstPossible;
        }
        return this.fAlign;
    }

    private boolean looksLikeArrayInitializerIntro() {
        this.nextToken();
        return this.fToken == 12 || this.skipBrackets();
    }

    private boolean skipNextIF() {
        Assert.isTrue((this.fToken == 1014 ? 1 : 0) != 0);
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: 
                case 14: {
                    this.skipScope();
                    continue block6;
                }
                case 109: {
                    return true;
                }
                case 1014: {
                    this.skipNextIF();
                    continue block6;
                }
                case -1: 
                case 1: 
                case 3: 
                case 5: {
                    return false;
                }
            }
        }
    }

    private boolean hasMatchingDo() {
        Assert.isTrue((this.fToken == 1017 ? 1 : 0) != 0);
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                this.skipScope();
            }
            case 7: {
                this.skipToStatementStart(false, false);
                return this.fToken == 1010;
            }
        }
        return false;
    }

    private boolean skipBrackets() {
        if (this.fToken == 4) {
            this.nextToken();
            if (this.fToken == 3) {
                return true;
            }
        }
        return false;
    }

    private void nextToken() {
        this.nextToken(this.fPosition);
    }

    private void nextToken(int start) {
        this.fToken = this.fScanner.previousToken(start - 1, -2);
        this.fPreviousPos = start;
        this.fPosition = this.fScanner.getPosition() + 1;
        try {
            this.fLine = this.fDocument.getLineOfOffset(this.fPosition);
        }
        catch (BadLocationException badLocationException) {
            this.fLine = -1;
        }
    }

    private boolean looksLikeMethodDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            do {
                this.nextToken();
            } while (this.skipBrackets());
            return this.fToken == 2000;
        }
        return false;
    }

    private boolean looksLikeAnonymousTypeDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            this.nextToken();
            while (this.fToken == 8) {
                this.nextToken();
                if (this.fToken != 2000) {
                    return false;
                }
                this.nextToken();
            }
            return this.fToken == 1025;
        }
        return false;
    }

    private boolean looksLikeMethodCall() {
        this.nextToken();
        return this.fToken == 2000;
    }

    private boolean skipScope(int openToken, int closeToken) {
        int depth = 1;
        while (true) {
            this.nextToken();
            if (this.fToken == closeToken) {
                ++depth;
                continue;
            }
            if (this.fToken == openToken) {
                if (--depth != 0) continue;
                return true;
            }
            if (this.fToken == -1) break;
        }
        return false;
    }

    private final class CorePrefs {
        final boolean prefUseTabs;
        final int prefTabSize;
        final int prefIndentationSize;
        final boolean prefArrayDimensionsDeepIndent;
        final int prefArrayIndent;
        final boolean prefArrayDeepIndent;
        final boolean prefTernaryDeepAlign;
        final int prefTernaryIndent;
        final int prefCaseIndent;
        final int prefAssignmentIndent;
        final int prefCaseBlockIndent;
        final int prefSimpleIndent;
        final int prefBracketIndent;
        final boolean prefMethodDeclDeepIndent;
        final int prefMethodDeclIndent;
        final boolean prefMethodCallDeepIndent;
        final int prefMethodCallIndent;
        final boolean prefParenthesisDeepIndent;
        final int prefParenthesisIndent;
        final int prefBlockIndent;
        final int prefMethodBodyIndent;
        final int prefTypeIndent;
        final boolean prefIndentBracesForBlocks;
        final boolean prefIndentBracesForArrays;
        final boolean prefIndentBracesForMethods;
        final boolean prefIndentBracesForTypes;
        final int prefContinuationIndent;
        final boolean prefHasGenerics;
        final String prefTabChar;
        private final IScriptProject fProject;
        JsPreferenceInterpreter prefs = new JsPreferenceInterpreter(JavaScriptUI.getDefault().getPreferenceStore());

        private boolean isStandalone() {
            return DLTKCore.getPlugin() == null;
        }

        private String getCoreFormatterOption(String key) {
            if (this.fProject == null) {
                return DLTKCore.getOption((String)key);
            }
            return this.fProject.getOption(key, true);
        }

        CorePrefs(IScriptProject project) {
            this.fProject = project;
            if (this.isStandalone()) {
                this.prefUseTabs = true;
                this.prefTabSize = 4;
                this.prefIndentationSize = 4;
                this.prefArrayDimensionsDeepIndent = true;
                this.prefContinuationIndent = 2;
                this.prefBlockIndent = 1;
                this.prefArrayIndent = this.prefContinuationIndent;
                this.prefArrayDeepIndent = true;
                this.prefTernaryDeepAlign = false;
                this.prefTernaryIndent = this.prefContinuationIndent;
                this.prefCaseIndent = 0;
                this.prefAssignmentIndent = this.prefBlockIndent;
                this.prefCaseBlockIndent = this.prefBlockIndent;
                this.prefIndentBracesForBlocks = false;
                this.prefSimpleIndent = this.prefIndentBracesForBlocks && this.prefBlockIndent == 0 ? 1 : this.prefBlockIndent;
                this.prefBracketIndent = this.prefBlockIndent;
                this.prefMethodDeclDeepIndent = true;
                this.prefMethodDeclIndent = 1;
                this.prefMethodCallDeepIndent = false;
                this.prefMethodCallIndent = 1;
                this.prefParenthesisDeepIndent = false;
                this.prefParenthesisIndent = this.prefContinuationIndent;
                this.prefMethodBodyIndent = 1;
                this.prefTypeIndent = 1;
                this.prefIndentBracesForArrays = false;
                this.prefIndentBracesForMethods = false;
                this.prefIndentBracesForTypes = false;
                this.prefHasGenerics = false;
                this.prefTabChar = "\t";
            } else {
                this.prefUseTabs = this.prefUseTabs();
                this.prefTabSize = this.prefTabSize();
                this.prefIndentationSize = this.prefIndentationSize();
                this.prefArrayDimensionsDeepIndent = this.prefArrayDimensionsDeepIndent();
                this.prefContinuationIndent = this.prefContinuationIndent();
                this.prefBlockIndent = this.prefBlockIndent();
                this.prefArrayIndent = this.prefArrayIndent();
                this.prefArrayDeepIndent = this.prefArrayDeepIndent();
                this.prefTernaryDeepAlign = this.prefTernaryDeepAlign();
                this.prefTernaryIndent = this.prefTernaryIndent();
                this.prefCaseIndent = this.prefCaseIndent();
                this.prefAssignmentIndent = this.prefAssignmentIndent();
                this.prefCaseBlockIndent = this.prefCaseBlockIndent();
                this.prefIndentBracesForBlocks = this.prefIndentBracesForBlocks();
                this.prefSimpleIndent = this.prefSimpleIndent();
                this.prefBracketIndent = this.prefBracketIndent();
                this.prefMethodDeclDeepIndent = this.prefMethodDeclDeepIndent();
                this.prefMethodDeclIndent = this.prefMethodDeclIndent();
                this.prefMethodCallDeepIndent = this.prefMethodCallDeepIndent();
                this.prefMethodCallIndent = this.prefMethodCallIndent();
                this.prefParenthesisDeepIndent = this.prefParenthesisDeepIndent();
                this.prefParenthesisIndent = this.prefParenthesisIndent();
                this.prefMethodBodyIndent = this.prefMethodBodyIndent();
                this.prefTypeIndent = this.prefTypeIndent();
                this.prefIndentBracesForArrays = this.prefIndentBracesForArrays();
                this.prefIndentBracesForMethods = this.prefIndentBracesForMethods();
                this.prefIndentBracesForTypes = this.prefIndentBracesForTypes();
                this.prefHasGenerics = this.hasGenerics();
                this.prefTabChar = this.prefUseTabs() ? "\t" : " ";
            }
        }

        private boolean prefUseTabs() {
            return this.prefs.getTabStyle() == TabStyle.TAB;
        }

        public int getTabWidth(IScriptProject project) {
            return this.prefs.getTabSize();
        }

        private int prefTabSize() {
            return this.getTabWidth(this.fProject);
        }

        public int getIndentWidth(IScriptProject project) {
            return this.prefs.getIndentSize();
        }

        private int prefIndentationSize() {
            return this.getIndentWidth(this.fProject);
        }

        private boolean prefArrayDimensionsDeepIndent() {
            return true;
        }

        private int prefArrayIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle(option) == 2) {
                    return 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return this.prefContinuationIndent();
        }

        private boolean prefArrayDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle(option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
        }

        private boolean prefTernaryDeepAlign() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_conditional_expression");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle(option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private int prefTernaryIndent() {
            block3: {
                String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_conditional_expression");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle(option) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return this.prefContinuationIndent();
                }
            }
            return this.prefContinuationIndent();
        }

        private int prefCaseIndent() {
            if ("true".equals(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.indent_switchstatements_compare_to_switch"))) {
                return this.prefBlockIndent();
            }
            return 0;
        }

        private int prefAssignmentIndent() {
            return this.prefBlockIndent();
        }

        private int prefCaseBlockIndent() {
            return this.prefBlockIndent();
        }

        private int prefSimpleIndent() {
            if (this.prefIndentBracesForBlocks() && this.prefBlockIndent() == 0) {
                return 1;
            }
            return this.prefBlockIndent();
        }

        private int prefBracketIndent() {
            return this.prefBlockIndent();
        }

        private boolean prefMethodDeclDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_parameters_in_method_declaration");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle(option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return true;
            }
        }

        private int prefMethodDeclIndent() {
            block3: {
                String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_parameters_in_method_declaration");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle(option) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 1;
                }
            }
            return this.prefContinuationIndent();
        }

        private boolean prefMethodCallDeepIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_arguments_in_method_invocation");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle(option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private int prefMethodCallIndent() {
            block3: {
                String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.alignment_for_arguments_in_method_invocation");
                try {
                    if (DefaultCodeFormatterConstants.getIndentStyle(option) != 2) break block3;
                    return 1;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return 1;
                }
            }
            return this.prefContinuationIndent();
        }

        private boolean prefParenthesisDeepIndent() {
            return false;
        }

        private int prefParenthesisIndent() {
            return this.prefContinuationIndent();
        }

        private int prefBlockIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.indent_statements_compare_to_block");
            if ("false".equals(option)) {
                return 0;
            }
            return 1;
        }

        private int prefMethodBodyIndent() {
            if ("false".equals(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.indent_statements_compare_to_body"))) {
                return 0;
            }
            return 1;
        }

        private int prefTypeIndent() {
            String option = this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.indent_body_declarations_compare_to_type_header");
            if ("false".equals(option)) {
                return 0;
            }
            return 1;
        }

        private boolean prefIndentBracesForBlocks() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.brace_position_for_block"));
        }

        private boolean prefIndentBracesForArrays() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.brace_position_for_array_initializer"));
        }

        private boolean prefIndentBracesForMethods() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.brace_position_for_method_declaration"));
        }

        private boolean prefIndentBracesForTypes() {
            return "next_line_shifted".equals(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.brace_position_for_type_declaration"));
        }

        private int prefContinuationIndent() {
            try {
                return Integer.parseInt(this.getCoreFormatterOption("org.eclipse.dltk.core.formatter.continuation_indentation"));
            }
            catch (NumberFormatException numberFormatException) {
                return 2;
            }
        }

        private boolean hasGenerics() {
            return false;
        }
    }
}

