/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextReference
implements IReference {
    private final HostCollection function;
    private final String key;
    private boolean local;
    private IReferenceLocation location;

    ContextReference(HostCollection function, String key) {
        this.function = function;
        this.key = key;
    }

    @Override
    public IReference getChild(String key, boolean resolveLocals) {
        return this.function.getReference(key);
    }

    @Override
    public Set<IReference> getChilds(boolean resolveLocals) {
        if (!resolveLocals) {
            return Collections.emptySet();
        }
        HashSet<IReference> hashSet = new HashSet<IReference>(this.function.getReferences().values());
        hashSet.remove(this);
        return hashSet;
    }

    @Override
    public String getName() {
        return this.key;
    }

    @Override
    public Set<String> getTypes() {
        IReference returnValue = this.function.getReference("!!!returnValue");
        if (returnValue != null) {
            return returnValue.getTypes();
        }
        return null;
    }

    @Override
    public IReference getPrototype(boolean resolveLocals) {
        return this.getChild("prototype", resolveLocals);
    }

    @Override
    public boolean isChildishReference() {
        return false;
    }

    @Override
    public void recordDelete(String fieldId) {
    }

    @Override
    public void setChild(String key, IReference ref) {
    }

    @Override
    public void setPrototype(IReference ref) {
    }

    @Override
    public void addModelElements(Collection<IModelElement> toAdd) {
    }

    public IReferenceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocationInformation(IReferenceLocation location) {
        this.location = location;
    }

    @Override
    public boolean isFunctionRef() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.key + "]";
    }
}

