/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.Collections;
import java.util.Set;
import org.eclipse.dltk.internal.javascript.ti.ChildReference;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.IValueReference;
import org.eclipse.dltk.internal.javascript.ti.ReferenceKind;
import org.eclipse.dltk.internal.javascript.ti.ReferenceLocation;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReference
implements IValueReference,
IValueProvider {
    @Override
    public abstract IValue getValue();

    @Override
    public abstract IValue createValue();

    @Override
    public void setValue(IValueReference value) {
        IValue val = this.createValue();
        if (val != null) {
            val.clear();
            if (value != null) {
                IValue src = ((IValueProvider)((Object)value)).getValue();
                if (src == null) {
                    return;
                }
                if (src instanceof Value && ((IValueProvider)((Object)value)).isReference()) {
                    val.addReference(src);
                } else {
                    val.addValue(src);
                }
            }
        }
    }

    @Override
    public void addValue(IValueReference value, boolean copy) {
        if (value == null) {
            return;
        }
        IValue val = this.createValue();
        if (val != null) {
            IValue src = ((IValueProvider)((Object)value)).getValue();
            if (src == null) {
                return;
            }
            if (!copy && src instanceof Value && ((IValueProvider)((Object)value)).isReference()) {
                val.addReference(src);
            } else {
                val.addValue(src);
            }
        }
    }

    @Override
    public void clear() {
        IValue value = this.getValue();
        if (value != null) {
            value.clear();
        }
    }

    @Override
    public boolean exists() {
        return this.getValue() != null;
    }

    @Override
    public Object getAttribute(String key) {
        IValue value = this.getValue();
        return value != null ? value.getAttribute(key) : null;
    }

    @Override
    public Type getDeclaredType() {
        IValue value = this.getValue();
        return value != null ? value.getDeclaredType() : null;
    }

    @Override
    public Set<Type> getDeclaredTypes() {
        IValue value = this.getValue();
        return value != null ? value.getDeclaredTypes() : Collections.emptySet();
    }

    @Override
    public ReferenceKind getKind() {
        IValue value = this.getValue();
        return value != null ? value.getKind() : ReferenceKind.UNKNOWN;
    }

    @Override
    public ReferenceLocation getLocation() {
        IValue value = this.getValue();
        return value != null ? value.getLocation() : ReferenceLocation.UNKNOWN;
    }

    @Override
    public Set<Type> getTypes() {
        IValue value = this.getValue();
        return value != null ? value.getTypes() : Collections.emptySet();
    }

    @Override
    public void setAttribute(String key, Object value) {
        IValue val = this.createValue();
        if (val != null) {
            val.setAttribute(key, value);
        }
    }

    @Override
    public void setDeclaredType(Type type) {
        IValue value = this.createValue();
        if (value != null) {
            value.setDeclaredType(type);
        }
    }

    @Override
    public void setKind(ReferenceKind kind) {
        IValue value = this.createValue();
        if (value != null) {
            value.setKind(kind);
        }
    }

    @Override
    public void setLocation(ReferenceLocation location) {
        IValue value = this.createValue();
        if (value != null) {
            value.setLocation(location);
        }
    }

    @Override
    public IValueReference getChild(String name) {
        return new ChildReference(this, name);
    }

    @Override
    public boolean hasChild(String name) {
        IValue value = this.getValue();
        return value != null && value.getChild(name, true) != null;
    }

    @Override
    public Set<String> getDirectChildren() {
        IValue value = this.getValue();
        return value != null ? value.getDirectChildren() : Collections.emptySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        IValue value = this.getValue();
        return value != null ? value.getDeletedChildren() : Collections.emptySet();
    }
}

