/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.Node;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import org.eclipse.dltk.internal.javascript.typeinference.PositionReachedException;

public class NodeSwitch {
    protected int position;
    protected ScriptOrFnNode context;

    public NodeSwitch(ScriptOrFnNode module, int position) {
        this.context = module;
        this.position = position;
    }

    public Object doAction(Node node, Object arg) {
        if (node.getPosition() > this.position && node.getType() != 56 && node.getType() != 3) {
            throw new PositionReachedException(this.context);
        }
        switch (node.getType()) {
            case 132: {
                return this.processScriptNode(node, arg);
            }
            case 66: {
                return this.processSetRefNode(node, arg);
            }
            case 138: {
                return this.processSetRefOpNode(node, arg);
            }
            case 55: {
                return this.processSetVarNode(node, arg);
            }
            case 105: {
                return this.processFunction(node, arg);
            }
            case 125: {
                return this.processBlock(node, arg);
            }
            case 118: {
                return this.processVarDeclaration(node, arg);
            }
            case 126: {
                return this.processLabelNode(node, arg);
            }
            case 129: {
                return this.processVoidExprNode(node, arg);
            }
            case 130: {
                return this.processExprResultNode(node, arg);
            }
            case 124: {
                return this.processEmptyNode(node, arg);
            }
            case 133: {
                return this.processTypeOfName(node, arg);
            }
            case 32: {
                return this.processTypeOf(node, arg);
            }
            case 136: {
                return this.processSetElemOpNode(node, arg);
            }
            case 128: {
                return this.processLoop(node, arg);
            }
            case 43: {
                return this.processFalse(node, arg);
            }
            case 44: {
                return this.processTrue(node, arg);
            }
            case 37: {
                return this.processCall(node, arg);
            }
            case 33: {
                return this.processGetPropNode(node, arg);
            }
            case 34: {
                return this.processSetPropNode(node, arg);
            }
            case 38: {
                return this.processNameNode(node, arg);
            }
            case 40: {
                return this.processStringNode(node, arg);
            }
            case 63: {
                return this.processArrayLitNode(node, arg);
            }
            case 64: {
                return this.processObjectLitNode(node, arg);
            }
            case 39: {
                return this.processNumberNode(node, arg);
            }
            case 41: {
                return this.processNullNode(node, arg);
            }
            case 137: {
                return this.processLabekBlock(node, arg);
            }
            case 77: {
                return this.processTryNode(node, arg);
            }
            case 113: {
                return this.processWhileNode(node, arg);
            }
            case 114: {
                return this.processDoNode(node, arg);
            }
            case 115: {
                return this.processForNode(node, arg);
            }
            case 5: {
                return this.processGotoNode(node, arg);
            }
            case 127: {
                return this.processTargetNode(node, arg);
            }
            case 56: {
                return this.processCatchScopeNode(node, arg);
            }
            case 53: {
                return this.processLocalLoad(node, arg);
            }
            case 98: {
                return this.processHookNode(node, arg);
            }
            case 26: {
                return this.processNotNode(node, arg);
            }
            case 30: {
                return this.processNewNode(node, arg);
            }
            case 35: {
                return this.processGetElemNode(node, arg);
            }
            case 36: {
                return this.processSetElemNode(node, arg);
            }
            case 47: {
                return this.processRegExp(node, arg);
            }
            case 48: {
                return this.processBindNameNode(node, arg);
            }
            case 8: {
                return this.processSetNameNode(node, arg);
            }
            case 9: {
                return this.processBitOrNode(node, arg);
            }
            case 10: {
                return this.processBitXorNode(node, arg);
            }
            case 11: {
                return this.processBitAndNode(node, arg);
            }
            case 57: {
                return this.processEnumInitKeys(node, arg);
            }
            case 58: {
                return this.processEnumInitValues(node, arg);
            }
            case 59: {
                return this.processEnumNext(node, arg);
            }
            case 12: {
                return this.processEqNode(node, arg);
            }
            case 6: {
                return this.processIfEqNode(node, arg);
            }
            case 13: {
                return this.processNE(node, arg);
            }
            case 17: {
                return this.processGE(node, arg);
            }
            case 18: {
                return this.processLSH(node, arg);
            }
            case 19: {
                return this.processRSH(node, arg);
            }
            case 24: {
                return this.processDiv(node, arg);
            }
            case 23: {
                return this.processMul(node, arg);
            }
            case 31: {
                return this.processDelProp(node, arg);
            }
            case 102: {
                return this.processINC(node, arg);
            }
            case 103: {
                return this.processGE(node, arg);
            }
            case 14: {
                return this.processLT(node, arg);
            }
            case 21: {
                return this.processAdd(node, arg);
            }
            case 122: {
                return this.processVoid(node, arg);
            }
            case 101: {
                return this.processAnd(node, arg);
            }
            case 42: {
                return this.processThis(node, arg);
            }
            case 100: {
                return this.processOr(node, arg);
            }
            case 86: {
                return this.processAssign(node, arg);
            }
            case 93: {
                return this.processAdd(node, arg);
            }
            case 89: {
                return this.processBitAnd(node, arg);
            }
            case 87: {
                return this.processBitOr(node, arg);
            }
            case 88: {
                return this.processBitXor(node, arg);
            }
            case 96: {
                return this.processDiv(node, arg);
            }
            case 90: {
                return this.processAssign_LSH(node, arg);
            }
            case 91: {
                return this.processAssign_RSH(node, arg);
            }
            case 94: {
                return this.processAssign_SUB(node, arg);
            }
            case 92: {
                return this.processAssign_URSH(node, arg);
            }
            case 27: {
                return this.processBitNot(node, arg);
            }
            case 116: {
                return this.processBreak(node, arg);
            }
            case 111: {
                return this.processCase(node, arg);
            }
            case 99: {
                return this.processColon(node, arg);
            }
            case 85: {
                return this.processComma(node, arg);
            }
            case 140: {
                return this.processColonColon(node, arg);
            }
            case 117: {
                return this.processContinue(node, arg);
            }
            case 112: {
                return this.processDefault(node, arg);
            }
            case 70: {
                return this.processDefaultNameSpace(node, arg);
            }
            case 67: {
                return this.processDelRef(node, arg);
            }
            case 109: {
                return this.processElse(node, arg);
            }
            case 2: {
                return this.processEnterWidth(node, arg);
            }
            case 3: {
                return this.processLeaveWidth(node, arg);
            }
            case 119: {
                return this.processWidth(node, arg);
            }
            case 7: {
                return this.processWidth(node, arg);
            }
            case 4: {
                return this.processReturn(node, arg);
            }
            case 62: {
                return this.processWidth(node, arg);
            }
            case 65: {
                return this.processWidth(node, arg);
            }
            case 110: {
                return this.processSwitch(node, arg);
            }
        }
        return this.processScriptNode(node, arg);
    }

    public Object processReturn(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processSwitch(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLeaveWidth(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processEnterWidth(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    private Object processSetVarNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    private Object processSetRefOpNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    private Object processSetRefNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processNE(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLSH(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processRSH(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processMul(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processDelProp(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processINC(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processGE(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLT(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processVoid(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAnd(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processThis(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processOr(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAssign(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAdd(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitAnd(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitOr(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitXor(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processDiv(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAssign_LSH(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAssign_RSH(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAssign_SUB(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processAssign_URSH(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitNot(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBreak(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processCase(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processColon(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processComma(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processColonColon(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processContinue(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processWidth(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processElse(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processDelRef(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processDefaultNameSpace(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processDefault(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processIfEqNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processEqNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processEnumNext(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processEnumInitValues(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processEnumInitKeys(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitOrNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitXorNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBitAndNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processSetNameNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBindNameNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processRegExp(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processSetElemNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processGetElemNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processNewNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processNotNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processHookNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLocalLoad(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processCatchScopeNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processTargetNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processGotoNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processForNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processDoNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processWhileNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processTryNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLabekBlock(Node node, Object arg) {
        node.getFirstChild();
        return this.processScriptNode(node, arg);
    }

    public Object processNullNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processNumberNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processObjectLitNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processArrayLitNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processStringNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processNameNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processSetPropNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processGetPropNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processCall(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processTrue(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processFalse(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLoop(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processSetElemOpNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processTypeOf(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processTypeOfName(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processEmptyNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processExprResultNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processVoidExprNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processLabelNode(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processBlock(Node node, Object arg) {
        Node nm = node.getFirstChild();
        if (nm instanceof Node.Jump) {
            Node.Jump jm = (Node.Jump)nm;
            int type = nm.getType();
            if (type == 7) {
                jm.getFirstChild().getType();
            }
        }
        return this.processScriptNode(node, arg);
    }

    public Object processFunction(Node node, Object arg) {
        return arg;
    }

    public Object processVarDeclaration(Node node, Object arg) {
        return this.processScriptNode(node, arg);
    }

    public Object processScriptNode(Node node, Object arg) {
        Node no = node.getFirstChild();
        while (no != null) {
            this.doAction(no, arg);
            no = no.getNext();
        }
        return null;
    }
}

