/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.impl;

import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;
import org.eclipse.dltk.javascript.core.dom.UnaryOperator;
import org.eclipse.dltk.javascript.core.dom.impl.ExpressionImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class UnaryExpressionImpl
extends ExpressionImpl
implements UnaryExpression {
    protected Expression argument;
    protected static final UnaryOperator OPERATION_EDEFAULT = UnaryOperator.POSTFIX_INC;
    protected UnaryOperator operation = OPERATION_EDEFAULT;

    protected UnaryExpressionImpl() {
    }

    protected EClass eStaticClass() {
        return DomPackage.Literals.UNARY_EXPRESSION;
    }

    public Expression getArgument() {
        return this.argument;
    }

    public NotificationChain basicSetArgument(Expression newArgument, NotificationChain msgs) {
        Expression oldArgument = this.argument;
        this.argument = newArgument;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldArgument, (Object)newArgument);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setArgument(Expression newArgument) {
        if (newArgument != this.argument) {
            NotificationChain msgs = null;
            if (this.argument != null) {
                msgs = ((InternalEObject)this.argument).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newArgument != null) {
                msgs = ((InternalEObject)newArgument).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetArgument(newArgument, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newArgument, (Object)newArgument));
        }
    }

    public UnaryOperator getOperation() {
        return this.operation;
    }

    public void setOperation(UnaryOperator newOperation) {
        UnaryOperator oldOperation = this.operation;
        UnaryOperator unaryOperator = this.operation = newOperation == null ? OPERATION_EDEFAULT : newOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldOperation, (Object)this.operation));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetArgument(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getArgument();
            }
            case 3: {
                return this.getOperation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setArgument((Expression)newValue);
                return;
            }
            case 3: {
                this.setOperation((UnaryOperator)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setArgument(null);
                return;
            }
            case 3: {
                this.setOperation(OPERATION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.argument != null;
            }
            case 3: {
                return this.operation != OPERATION_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operation: ");
        result.append((Object)this.operation);
        result.append(')');
        return result.toString();
    }
}

