/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.manipulation.RefactoringChecks;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.javascript.core.manipulation.JavascriptManipulationPlugin;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.Checks;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.DomFactory;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ExpressionStatement;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.VariableDeclaration;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.VariableStatement;
import org.eclipse.dltk.javascript.core.dom.rewrite.ASTConverter;
import org.eclipse.dltk.javascript.core.dom.rewrite.NodeFinder;
import org.eclipse.dltk.javascript.core.dom.rewrite.RewriteAnalyzer;
import org.eclipse.dltk.javascript.core.dom.rewrite.VariableLookup;
import org.eclipse.dltk.javascript.core.refactoring.descriptors.ExtractLocalDescriptor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractTempRefactoring
extends Refactoring {
    private Source fCompilationUnitNode;
    private ISourceModule fCu;
    private String fSource;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private Expression fSelectedExpression;
    private int fSelectionLength;
    private int fSelectionStart;
    private String fTempName;
    private SourceModuleChange fChange;

    private static boolean isUsedInFor(Expression expression) {
        EStructuralFeature sf = expression.eContainingFeature();
        if (sf == DomPackage.eINSTANCE.getForStatement_Initialization()) {
            return true;
        }
        if (sf == DomPackage.eINSTANCE.getForStatement_Condition()) {
            return true;
        }
        if (sf == DomPackage.eINSTANCE.getForStatement_Increment()) {
            return true;
        }
        if (sf == DomPackage.eINSTANCE.getForInStatement_Item()) {
            return true;
        }
        return sf == DomPackage.eINSTANCE.getForEachInStatement_Item();
    }

    public ExtractTempRefactoring(ISourceModule unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fCompilationUnitNode = null;
        this.fReplaceAllOccurrences = true;
        this.fTempName = "";
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 4);
            ChangeRecorder cr = new ChangeRecorder((EObject)this.fCompilationUnitNode);
            Expression selected = this.getSelectedExpression();
            Expression[] expressions = this.fReplaceAllOccurrences ? ExtractTempRefactoring.findSimilarExpressions(selected) : new Expression[]{selected};
            Statement stmt = ExtractTempRefactoring.findFirstStatement(expressions[0], expressions[expressions.length - 1]);
            EReference stmtRef = stmt.eContainmentFeature();
            Expression[] expressionArray = expressions;
            int n = expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expr = expressionArray[n2];
                Identifier refId = DomFactory.eINSTANCE.createIdentifier();
                refId.setName(this.fTempName);
                VariableReference varRef = DomFactory.eINSTANCE.createVariableReference();
                varRef.setVariable(refId);
                EReference exprRef = expr.eContainmentFeature();
                if (exprRef.isMany()) {
                    EList exprList = (EList)expr.eContainer().eGet((EStructuralFeature)exprRef);
                    exprList.set(exprList.lastIndexOf((Object)expr), (Object)varRef);
                } else {
                    expr.eContainer().eSet((EStructuralFeature)exprRef, (Object)varRef);
                }
                ++n2;
            }
            Identifier declId = DomFactory.eINSTANCE.createIdentifier();
            declId.setName(this.fTempName);
            VariableDeclaration decl = DomFactory.eINSTANCE.createVariableDeclaration();
            decl.setIdentifier(declId);
            decl.setInitializer(selected);
            VariableStatement varStmt = DomFactory.eINSTANCE.createVariableStatement();
            varStmt.getDeclarations().add((Object)decl);
            if (stmtRef.isMany()) {
                EList stmtList = (EList)stmt.eContainer().eGet((EStructuralFeature)stmtRef);
                stmtList.add(stmtList.lastIndexOf((Object)stmt), (Object)varStmt);
            } else {
                BlockStatement block = DomFactory.eINSTANCE.createBlockStatement();
                block.getStatements().add((Object)varStmt);
                stmt.eContainer().eSet((EStructuralFeature)stmtRef, (Object)block);
                block.getStatements().add((Object)stmt);
            }
            ChangeDescription cd = cr.endRecording();
            final SourceModuleChange change = new SourceModuleChange(RefactoringCoreMessages.ExtractTempRefactoring_name, this.fCu);
            final TextEditGroup addDecl = new TextEditGroup(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable);
            RewriteAnalyzer ra = new RewriteAnalyzer(cd, this.fCu.getSource()){

                protected void addEdit(TextEdit edit, Node node) {
                    if (node instanceof VariableReference) {
                        change.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.ExtractTempRefactoring_replace, edit));
                    } else {
                        addDecl.addTextEdit(edit);
                    }
                    super.addEdit(edit, node);
                }
            };
            change.setEdit(ra.getEdit());
            ra.rewrite(this.fCompilationUnitNode);
            change.addTextEditGroup(addDecl);
            cd.apply();
            this.fChange = change;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private static Expression[] findSimilarExpressions(Expression expr) {
        int cl;
        ArrayList<Expression> res = new ArrayList<Expression>();
        Node root = (Node)expr.eContainer();
        while ((cl = root.eClass().getClassifierID()) != 20 && cl != 21 && cl != 56 && cl != 58) {
            root = (Node)root.eContainer();
        }
        HashSet<Identifier> set = new HashSet<Identifier>();
        set.addAll(VariableLookup.findReferences(root, VariableLookup.getVisibleNames(expr)));
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            Node cur = (Node)it.next();
            if (!ExtractTempRefactoring.match(expr, cur, set)) continue;
            res.add((Expression)cur);
            it.prune();
        }
        return res.toArray(new Expression[res.size()]);
    }

    private static boolean match(Node one, Node another, Set<Identifier> resolved) {
        if (one == null) {
            return another == null;
        }
        EClass cl = one.eClass();
        if (cl != another.eClass()) {
            return false;
        }
        if (resolved.contains(one) != resolved.contains(another)) {
            return false;
        }
        for (EAttribute attr : cl.getEAllAttributes()) {
            if (attr.getFeatureID() == 0 || attr.getFeatureID() == 1 || attr == DomPackage.eINSTANCE.getBinaryExpression_OperatorPosition() || attr == DomPackage.eINSTANCE.getFunctionExpression_ParametersPosition() || one.eGet((EStructuralFeature)attr).equals(another.eGet((EStructuralFeature)attr))) continue;
            return false;
        }
        for (EReference ref : cl.getEAllReferences()) {
            if (ref.isMany()) {
                List first = (List)one.eGet((EStructuralFeature)ref);
                List second = (List)another.eGet((EStructuralFeature)ref);
                if (first.size() != second.size()) {
                    return false;
                }
                int i = 0;
                while (i < first.size()) {
                    if (!ExtractTempRefactoring.match((Node)first.get(i), (Node)second.get(i), resolved)) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (ExtractTempRefactoring.match((Node)one.eGet((EStructuralFeature)ref), (Node)another.eGet((EStructuralFeature)ref), resolved)) continue;
            return false;
        }
        return true;
    }

    private static Statement findFirstStatement(EObject first, EObject last) {
        int x = ExtractTempRefactoring.getDepth(first);
        int y = ExtractTempRefactoring.getDepth(last);
        while (x > y) {
            --x;
            first = first.eContainer();
        }
        while (y > x) {
            --y;
            last = last.eContainer();
        }
        while (first.eContainer() != last.eContainer()) {
            first = first.eContainer();
            last = last.eContainer();
        }
        while (first.eContainmentFeature().getEReferenceType() != DomPackage.eINSTANCE.getStatement()) {
            first = first.eContainer();
        }
        return (Statement)first;
    }

    private static int getDepth(EObject node) {
        int i = 0;
        while (node != null) {
            ++i;
            node = node.eContainer();
        }
        return i;
    }

    private ExtractLocalDescriptor createRefactoringDescriptor() {
        String project = null;
        IScriptProject scriptProject = this.fCu.getScriptProject();
        if (scriptProject != null) {
            project = scriptProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, this.fTempName);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("input", ScriptRefactoringDescriptor.elementToHandle((String)project, (IModelElement)this.fCu));
        arguments.put("name", this.fTempName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        ExtractLocalDescriptor descriptor = new ExtractLocalDescriptor(project, description, "", arguments, 0);
        return descriptor;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 6);
            RefactoringStatus result = RefactoringChecks.validateModifiesFiles((IFile[])ResourceUtil.getFiles((ISourceModule[])new ISourceModule[]{this.fCu}), (Object)this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fCompilationUnitNode == null) {
                this.fCompilationUnitNode = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)this.fCu));
            }
            pm.worked(3);
            this.fSource = this.fCu.getSource();
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws ModelException {
        try {
            pm.beginTask("", 2);
            Expression selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isUsedInFor(this.getSelectedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.validateIdentifier(newName);
        if (status.hasFatalError()) {
            return status;
        }
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, newName));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            ExtractLocalDescriptor descriptor = this.createRefactoringDescriptor();
            this.fChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            SourceModuleChange sourceModuleChange = this.fChange;
            return sourceModuleChange;
        }
        finally {
            pm.done();
        }
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                Set<String> visible = VariableLookup.getVisibleNames(this.getSelectedExpression());
                this.fExcludedVariableNames = visible.toArray(new String[visible.size()]);
            }
            catch (ModelException e) {
                JavascriptManipulationPlugin.log(e);
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private Expression getSelectedExpression() throws ModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        Node node = NodeFinder.findNode(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionStart + this.fSelectionLength);
        if (node == null) {
            return null;
        }
        int i = this.fSelectionStart;
        while (i < node.getBegin()) {
            if (!Character.isWhitespace(this.fSource.charAt(i))) {
                return null;
            }
            ++i;
        }
        i = node.getEnd();
        while (i < this.fSelectionStart + this.fSelectionLength) {
            if (!Character.isWhitespace(this.fSource.charAt(i))) {
                return null;
            }
            ++i;
        }
        if (node instanceof ExpressionStatement) {
            this.fSelectedExpression = ((ExpressionStatement)node).getExpression();
            return this.fSelectedExpression;
        }
        if (node instanceof Expression) {
            this.fSelectedExpression = (Expression)node;
            return this.fSelectedExpression;
        }
        return null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }
}

