/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.search.mixin;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclFieldDeclaration;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclInstanceVariable;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclMethodDeclaration;
import org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclClass;
import org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclClassInstance;
import org.eclipse.dltk.itcl.internal.core.search.mixin.model.IncrTclInstProc;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.ast.ExtendedTclMethodDeclaration;
import org.eclipse.dltk.tcl.core.extensions.IMixinBuildVisitorExtension;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinBuildVisitor;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclField;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclProc;

public class IncrTclMixinBuildVisitorExtension
implements IMixinBuildVisitorExtension {
    public boolean visit(MethodDeclaration s, TclMixinBuildVisitor original) {
        if (s instanceof IncrTclMethodDeclaration) {
            this.visitIncrTclMethod(s, original);
            return true;
        }
        return false;
    }

    private void visitIncrTclMethod(MethodDeclaration s, TclMixinBuildVisitor original) {
        ExtendedTclMethodDeclaration method = (ExtendedTclMethodDeclaration)s;
        IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
        String name = s.getName();
        ASTNode declaringType = method.getDeclaringType();
        if (declaringType != null && declaringType instanceof TypeDeclaration) {
            List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)original.getModuleDeclaration(), (ASTNode)declaringType);
            info.key = String.valueOf(original.getKeyFromLevels(levels)) + "{" + original.tclNameToKey(name);
        }
        if (original.getSignature()) {
            switch (method.getKind()) {
                case 1: {
                    info.object = new IncrTclInstProc();
                    break;
                }
                case 0: {
                    info.object = new TclProc();
                }
            }
        }
        if (info.key != null) {
            original.getRequestor().reportElement(info);
        }
    }

    public boolean visit(TypeDeclaration s, TclMixinBuildVisitor original) {
        if ((s.getModifiers() & 0x200000) != 0) {
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = String.valueOf(original.getNamespacePrefix()) + original.tclNameToKey(s.getName());
            if (info.key.startsWith("{")) {
                info.key = info.key.substring(1);
            }
            original.pushNamespaceName(s);
            if (original.getSignature()) {
                IncrTclClass tclClass = new IncrTclClass();
                info.object = tclClass;
                tclClass.setNamespace(original.getNamespacePrefix());
            }
            original.getRequestor().reportElement(info);
            return true;
        }
        return false;
    }

    public boolean visit(Statement s, TclMixinBuildVisitor original) {
        if (s instanceof IncrTclInstanceVariable) {
            IncrTclInstanceVariable instanceVar = (IncrTclInstanceVariable)s;
            List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)original.getModuleDeclaration(), (ASTNode)instanceVar);
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = original.getKeyFromLevels(levels);
            if (original.getSignature()) {
                info.object = new IncrTclClassInstance();
            }
            original.getRequestor().reportElement(info);
            return true;
        }
        if (s instanceof IncrTclFieldDeclaration) {
            IncrTclFieldDeclaration var = (IncrTclFieldDeclaration)s;
            String name = var.getName();
            TypeDeclaration type = var.getDeclaringType();
            List levels = TclParseUtil.findLevelsTo((ModuleDeclaration)original.getModuleDeclaration(), (ASTNode)type);
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = String.valueOf(original.getKeyFromLevels(levels)) + "{" + original.tclNameToKey(name);
            if (original.getSignature()) {
                info.object = new TclField();
            }
            original.getRequestor().reportElement(info);
            return true;
        }
        return false;
    }
}

