/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.display;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.internal.ScriptConsolePage;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.display.DebugConsole;
import org.eclipse.dltk.debug.ui.display.OpenInputFieldAction;
import org.eclipse.dltk.debug.ui.display.ResetOnLaunchAction;
import org.eclipse.dltk.debug.ui.display.RunInputFieldAction;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.IUpdate;

public class DebugConsolePage
extends ScriptConsolePage {
    private DebugEventListener debugEventListener = null;
    private IAction runAction;
    private IAction resetOnLaunchAction;
    private boolean resetOnLaunch;
    private SashForm sash;
    private StyledText inputField;
    private boolean enabled = true;
    private final Job enableUpdateJob = new Job("Enable update"){

        protected IStatus run(IProgressMonitor monitor) {
            DLTKDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    DebugConsolePage.access$1(1.access$0(this.this$1), DebugConsolePage.access$0(1.access$0(this.this$1)));
                }
            });
            return Status.OK_STATUS;
        }

        static /* synthetic */ DebugConsolePage access$0(1 var0) {
            return var0.DebugConsolePage.this;
        }
    };

    public DebugConsolePage(ScriptConsole console, IConsoleView view, SourceViewerConfiguration cfg) {
        super(console, view, cfg);
    }

    protected IAction createTerminateConsoleAction() {
        return null;
    }

    protected void createActions() {
        super.createActions();
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager tbManager = actionBars.getToolBarManager();
        tbManager.appendToGroup("scriptGroup", (IAction)new OpenInputFieldAction(this));
        this.runAction = new RunInputFieldAction(this);
        tbManager.appendToGroup("scriptGroup", this.runAction);
        this.resetOnLaunchAction = new ResetOnLaunchAction(this);
        this.resetOnLaunchAction.setChecked(this.resetOnLaunch);
        actionBars.getMenuManager().add(this.resetOnLaunchAction);
        this.updateActions();
    }

    private void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            this.inputField.setEditable(value);
            this.getViewer().setEditable(value);
            Control control = this.getViewer().getControl();
            control.setBackground(value ? null : control.getDisplay().getSystemColor(22));
        }
    }

    public void createControl(Composite parent) {
        this.sash = new SashForm(parent, 66048);
        this.inputField = new StyledText((Composite)this.sash, 768);
        this.inputField.setEditable(true);
        super.createControl((Composite)this.sash);
        this.inputField.setFont(this.getViewer().getControl().getFont());
        this.inputField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugConsolePage.this.updateActions();
            }
        });
        this.sash.setMaximizedControl(this.getViewer().getControl());
        this.setEnabled(this.isDebuggerAvailable());
        if (this.debugEventListener == null) {
            this.debugEventListener = new DebugEventListener();
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.debugEventListener);
        }
        this.enableUpdateJob.schedule(500L);
    }

    private boolean isDebuggerAvailable() {
        IScriptThread thread;
        IPageSite site = this.getSite();
        if (site == null) {
            return false;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return false;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        IScriptStackFrame frame = ScriptEvaluationContextManager.getEvaluationContext(part);
        if (frame != null && (thread = frame.getScriptThread()) != null) {
            return thread.isSuspended();
        }
        return false;
    }

    public void dispose() {
        if (this.debugEventListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.debugEventListener);
            this.debugEventListener = null;
        }
        super.dispose();
    }

    public boolean canExecuteInputField() {
        return this.sash.getMaximizedControl() == null && this.inputField.getText().length() != 0;
    }

    public void openInputField() {
        this.sash.setWeights(new int[]{30, 70});
        this.sash.setMaximizedControl(null);
        this.inputField.setFocus();
        this.updateActions();
    }

    public void closeInputField() {
        Control consoleControl = this.getControl();
        this.sash.setMaximizedControl(consoleControl);
        consoleControl.setFocus();
        this.updateActions();
    }

    private void updateActions() {
        if (this.runAction instanceof IUpdate) {
            ((IUpdate)this.runAction).update();
        }
    }

    public void executeInputField() {
        String input = this.inputField.getText();
        ((ScriptConsole)this.getConsole()).executeCommand(input);
    }

    private static boolean isTargetCreate(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 4 && event.getSource() instanceof IDebugTarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isResetOnLaunch() {
        return this.resetOnLaunch;
    }

    public void setResetOnLaunch(boolean resetOnLaunch) {
        this.resetOnLaunch = resetOnLaunch;
    }

    static /* synthetic */ boolean access$0(DebugConsolePage debugConsolePage) {
        return debugConsolePage.isDebuggerAvailable();
    }

    static /* synthetic */ void access$1(DebugConsolePage debugConsolePage, boolean bl) {
        debugConsolePage.setEnabled(bl);
    }

    static /* synthetic */ IConsole access$5(DebugConsolePage debugConsolePage) {
        return debugConsolePage.getConsole();
    }

    private final class DebugEventListener
    implements IDebugEventSetListener {
        private DebugEventListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugConsolePage.this.enableUpdateJob.schedule(500L);
            if (DebugConsolePage.this.resetOnLaunch && DebugConsolePage.isTargetCreate(events)) {
                DLTKDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ DebugEventListener this$1;
                    {
                        this.this$1 = debugEventListener;
                    }

                    public void run() {
                        ((DebugConsole)DebugConsolePage.access$5(DebugEventListener.access$1(this.this$1))).clearConsole();
                    }
                });
            }
        }

        static /* synthetic */ DebugConsolePage access$1(DebugEventListener debugEventListener) {
            return debugEventListener.DebugConsolePage.this;
        }
    }
}

