/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.collections.map.ReferenceMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.IFileCacheManagement;
import org.eclipse.dltk.internal.core.util.Util;

public class SourceCodeCache
implements IFileCacheManagement {
    private static final String ID = "org.eclipse.dltk.core.fileCache.default";
    private IResourceChangeListener listener = new ChangeListener();
    private final ReferenceMap resourceMap = new ReferenceMap(0, 1);
    private static final long EXTERNAL_CACHE_LIFETIME = 600000L;
    private final ReferenceMap externalResourceMap = new ReferenceMap(0, 1);

    public String getId() {
        return ID;
    }

    private static boolean isChanged(IResourceDelta delta) {
        return delta.getKind() == 4 && (delta.getFlags() & 0x40100) != 0;
    }

    private static boolean isRemoved(IResourceDelta delta) {
        return delta.getKind() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFileEntry(IFile resource) {
        ReferenceMap referenceMap = this.resourceMap;
        synchronized (referenceMap) {
            this.resourceMap.remove(resource);
        }
    }

    public void start() {
        DLTKCore.addPreProcessingResourceChangedListener(this.listener, 1);
    }

    public void stop() {
        DLTKCore.removePreProcessingResourceChangedListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContentsIfCached(IFile file) {
        ResourceCacheEntry entry;
        ReferenceMap referenceMap = this.resourceMap;
        synchronized (referenceMap) {
            entry = (ResourceCacheEntry)this.resourceMap.get(file);
        }
        if (entry != null) {
            return new ByteArrayInputStream(entry.content);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] get(IFile file) throws ModelException {
        char[] result;
        ResourceCacheEntry entry;
        ReferenceMap referenceMap = this.resourceMap;
        synchronized (referenceMap) {
            entry = (ResourceCacheEntry)this.resourceMap.get(file);
        }
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        if (entry != null) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(entry.content);
                char[] result2 = org.eclipse.dltk.compiler.util.Util.getInputStreamAsCharArray(stream, entry.charLength, encoding);
                stream.close();
                return result2;
            }
            catch (IOException e) {
                throw new ModelException(e, 985);
            }
        }
        byte[] content = Util.getResourceContentsAsByteArray(file);
        try {
            result = org.eclipse.dltk.compiler.util.Util.getInputStreamAsCharArray(new ByteArrayInputStream(content), content.length, encoding);
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
        ReferenceMap referenceMap2 = this.resourceMap;
        synchronized (referenceMap2) {
            this.resourceMap.put(file, new ResourceCacheEntry(result.length, content));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] get(IFileHandle file) throws ModelException {
        ReferenceMap referenceMap = this.externalResourceMap;
        synchronized (referenceMap) {
            ExternalCacheEntry entry = (ExternalCacheEntry)this.externalResourceMap.get(file);
            if (entry != null && entry.addTime + 600000L > System.currentTimeMillis()) {
                return entry.content;
            }
        }
        char[] result = Util.getResourceContentsAsCharArrayNoCache(file);
        ReferenceMap referenceMap2 = this.externalResourceMap;
        synchronized (referenceMap2) {
            this.externalResourceMap.put(file, new ExternalCacheEntry(result, System.currentTimeMillis()));
        }
        return result;
    }

    public final void remove(IFile file) {
        this.removeFileEntry(file);
    }

    public void beginOperation() {
    }

    public void endOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReferenceMap referenceMap = this.resourceMap;
        synchronized (referenceMap) {
            this.resourceMap.clear();
        }
    }

    private class ChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            block2: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (SourceCodeCache.isChanged(delta) || SourceCodeCache.isRemoved(delta)) {
                    SourceCodeCache.this.removeFileEntry((IFile)resource);
                }
                return false;
            }
            return true;
        }
    }

    private static class ExternalCacheEntry {
        final char[] content;
        final long addTime;

        public ExternalCacheEntry(char[] result, long currentTimeMillis) {
            this.content = result;
            this.addTime = currentTimeMillis;
        }
    }

    private static class ResourceCacheEntry {
        final byte[] content;
        final int charLength;

        public ResourceCacheEntry(int charLength, byte[] content) {
            this.charLength = charLength;
            this.content = content;
        }
    }
}

