/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.update;

import java.util.NoSuchElementException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.internal.rhelp.server.update.REnvServiController;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.rmi.RMIRegistryManager;
import org.eclipse.statet.jcommons.runtime.ClassLoaderUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.servi.RServi;
import org.eclipse.statet.rj.servi.RServiUtils;
import org.eclipse.statet.rj.servi.node.RServiImpl;
import org.eclipse.statet.rj.servi.node.RServiNodeConfig;
import org.eclipse.statet.rj.servi.node.RServiNodeFactory;
import org.eclipse.statet.rj.servi.node.RServiNodeManager;

@NonNullByDefault
public class REnvServiController {
    private static final int LOCAL_RENV = 1;
    private static final int POOL = 3;
    private static final Config NO_CONFIG = new Config(0);
    private static final Object CLASSPATH_STATIC_LOCK = new Object();
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable REnvServiController.NodeConfigureExt classPathConfigurator;
    private final REnv rEnv;
    private @Nullable RServiNodeConfig localConfig;
    private Config current = NO_CONFIG;

    public REnvServiController(REnv rEnv) {
        this.rEnv = rEnv;
    }

    public void configure() throws StatusException {
        REnvConfiguration rEnvConfig = (REnvConfiguration)this.rEnv.get(REnvConfiguration.class);
        if (rEnvConfig == null) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "The configuration for R environment is missing."));
        }
        RServiNodeConfig rServiConfig = new RServiNodeConfig();
        rServiConfig.load(rEnvConfig);
        this.configureClassPath(rServiConfig);
        this.localConfig = rServiConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureClassPath(RServiNodeConfig rServiConfig) throws StatusException {
        NodeConfigureExt configurator;
        Object object = CLASSPATH_STATIC_LOCK;
        synchronized (object) {
            configurator = classPathConfigurator;
            if (configurator == null) {
                try {
                    configurator = new ProtocolHandlerConfigurator("org.springframework.boot.loader.net.protocol");
                }
                catch (Exception e) {
                    String url = ClassLoaderUtils.getClassLocationUrlString(REnvServiController.class);
                    if (UriUtils.isFileUrl((String)url)) {
                        configurator = new NoopConfigurator();
                    }
                    try {
                        configurator = new ProtocolHandlerConfigurator("org.springframework.boot.loader");
                    }
                    catch (Exception ignore) {
                        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "An error occurred when configuring protocol handler for fat jar.", (Throwable)e));
                    }
                }
                classPathConfigurator = configurator;
            }
        }
        configurator.configure(rServiConfig);
    }

    public void startR(ProgressMonitor m) throws StatusException {
        this.startLocal(new Config(1), m);
    }

    public void stopR() {
        this.set(NO_CONFIG);
    }

    public void setPool(String poolAddress) {
        Config config = new Config(3);
        config.address = poolAddress;
        this.set(config);
    }

    private void startLocal(Config config, ProgressMonitor m) throws StatusException {
        ObjectUtils.nonNullAssert((Object)config);
        RServiNodeConfig rServiConfig = this.localConfig;
        if (rServiConfig == null) {
            throw new IllegalStateException("R is not yet configured.");
        }
        try {
            RJContext context = new RJContext();
            RMIRegistry registry = RMIRegistryManager.INSTANCE.getEmbeddedPrivateRegistry(m);
            RServiNodeFactory nodeFactory = RServiImpl.createLocalNodeFactory((String)this.rEnv.getId(), (RJContext)context);
            nodeFactory.setRegistry(registry);
            nodeFactory.setConfig(rServiConfig);
            RServiNodeManager localR = RServiImpl.createNodeManager((String)this.rEnv.getId(), (RMIRegistry)registry, (RServiNodeFactory)nodeFactory);
            localR.start();
            config.localR = localR;
            this.set(config);
        }
        catch (RjException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "Local R instance could not created.", (Throwable)e));
        }
    }

    private void dispose(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable REnvServiController.Config config) {
        if (config == null) {
            return;
        }
        RServiNodeManager localR = config.localR;
        if (localR != null) {
            localR.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Config config) {
        Config previous;
        REnvServiController rEnvServiController = this;
        synchronized (rEnvServiController) {
            previous = this.current;
            this.current = config;
        }
        this.dispose(previous);
    }

    public RServi getRServi(String task) throws StatusException {
        Config config = this.current;
        String key = this.rEnv.getId() + "->" + task;
        try {
            switch (config.mode) {
                case 1: {
                    return RServiUtils.getRServi((RServiNodeManager)config.localR, (String)key);
                }
                case 3: {
                    return RServiUtils.getRServi((String)config.address, (String)key);
                }
            }
        }
        catch (LoginException | StatusException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "R not available, please check the configuration.", e));
        }
        catch (NoSuchElementException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "R currently not available, please try again later.", (Throwable)e));
        }
        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", "R is not configured, please check the configuration."));
    }
}

