/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RUniqueCharacter32Store;

@NonNullByDefault
public class RUniqueCharacterHash32Store
extends RUniqueCharacter32Store {
    private final HashMap<@Nullable String, Integer> map = new HashMap();

    public RUniqueCharacterHash32Store(@Nullable String[] initialValues) {
        super(initialValues);
        this.initMap();
    }

    RUniqueCharacterHash32Store(RCharacter32Store source, boolean reuse) {
        super(source, reuse);
        this.initMap();
    }

    public RUniqueCharacterHash32Store(RJIO io, int length) throws IOException {
        super(io, length);
        this.initMap();
    }

    protected void initMap() {
        int length = (int)this.getLength();
        int idx = 0;
        while (idx < length) {
            this.map.put(this.charValues[idx], idx);
            ++idx;
        }
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= this.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.setNA((int)idx);
    }

    @Override
    public void setNA(int idx) {
        String previous = this.getChar(idx);
        super.setNA(idx);
        this.map.remove(previous);
        this.map.put(null, idx);
    }

    @Override
    public void insertNA(int idx) {
        super.insertNA(idx);
        this.map.put(null, idx);
    }

    @Override
    public void setChar(long idx, String value) {
        if (idx < 0L || idx >= this.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.setChar((int)idx, value);
    }

    @Override
    public void setChar(int idx, String value) {
        String previous = this.getChar(idx);
        super.setChar(idx, value);
        this.map.remove(previous);
        this.map.put(value, idx);
    }

    @Override
    public void insertChar(int idx, String name) {
        super.insertChar(idx, name);
        this.map.put(name, idx);
    }

    @Override
    public void remove(int idx) {
        this.map.remove(this.getChar(idx));
        super.remove(idx);
    }

    @Override
    public boolean containsNA() {
        return this.map.containsKey(null);
    }

    @Override
    public long indexOfNA(long fromIdx) {
        int idx;
        Integer index = this.map.get(null);
        if (index != null && (long)(idx = index.intValue()) >= fromIdx) {
            return idx;
        }
        return -1L;
    }

    @Override
    public int indexOfNA(int fromIdx) {
        int idx;
        Integer index = this.map.get(null);
        if (index != null && (idx = index.intValue()) >= fromIdx) {
            return idx;
        }
        return -1;
    }

    @Override
    public boolean contains(String value) {
        return value != null && this.map.containsKey(value);
    }

    @Override
    public long indexOf(String name, long fromIdx) {
        int idx;
        Integer index = this.map.get(name);
        if (index != null && (long)(idx = index.intValue()) >= fromIdx) {
            return idx;
        }
        return -1L;
    }

    @Override
    public int indexOf(String name, int fromIdx) {
        int idx;
        Integer index = this.map.get(name);
        if (index != null && (idx = index.intValue()) >= fromIdx) {
            return idx;
        }
        return -1;
    }
}

