/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.model.build;

import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.internal.yaml.core.model.AstProblemReporter;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.build.BasicIssueReporter;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.yaml.core.model.YamlCompositeSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.build.YamlTaskTagReporter;

@NonNullByDefault
public class YamlIssueReporter
extends BasicIssueReporter<SourceUnit, YamlSourceUnitModelInfo> {
    private final AstProblemReporter syntaxProblemReporter = new AstProblemReporter();
    private final YamlTaskTagReporter taskReporter = new YamlTaskTagReporter();

    public YamlIssueReporter() {
        super("Yaml");
    }

    protected YamlTaskTagReporter getTaskReporter() {
        return this.taskReporter;
    }

    protected void runReporters(SourceUnit sourceUnit, YamlSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        YamlSourceElement element = modelInfo.getSourceElement();
        if (element instanceof YamlCompositeSourceElement) {
            ImList<? extends YamlSourceElement> elements = ((YamlCompositeSourceElement)element).getCompositeElements();
            for (YamlSourceElement yamlChunk : elements) {
                this.runReporters(sourceUnit, (AstNode)yamlChunk.getAdapter(AstNode.class), modelInfo, content, requestor, level);
            }
        } else {
            this.runReporters(sourceUnit, (AstNode)element.getAdapter(AstNode.class), modelInfo, content, requestor, level);
        }
    }

    protected void runReporters(SourceUnit sourceUnit, @Nullable AstNode node, @Nullable YamlSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (node == null) {
            return;
        }
        if (node instanceof DslAstNode) {
            this.runReporters(sourceUnit, (DslAstNode)node, modelInfo, content, requestor, level);
        }
    }

    private void runReporters(SourceUnit sourceUnit, DslAstNode node, @Nullable YamlSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (this.shouldReportProblems()) {
            this.syntaxProblemReporter.run(node, content, requestor);
        }
        if (this.shouldReportTasks()) {
            this.taskReporter.run(sourceUnit, node, content, requestor);
        }
    }
}

