/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.AbstractRDataAdapter;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;

public class RArrayAsVectorDataAdapter
extends AbstractRDataAdapter<RArray<?>, RVector<?>> {
    @Override
    public RArray<?> validate(RObject rObject) throws UnexpectedRDataException {
        return RDataUtils.checkRArray((RObject)rObject);
    }

    @Override
    public RArray<?> validate(RObject rObject, RArray<?> referenceObject, int flags) throws UnexpectedRDataException {
        RArray array = RDataUtils.checkRArray((RObject)rObject, (long)referenceObject.getDim().getLength());
        if ((flags & 1) != 0) {
            RDataUtils.checkLengthEqual((RObject)array, (long)referenceObject.getLength());
        }
        if ((flags & 4) != 0) {
            RDataUtils.checkData((RStore)array.getData(), (byte)referenceObject.getData().getStoreType());
        }
        return array;
    }

    @Override
    public long getRowCount(RArray<?> rObject) {
        return rObject.getLength();
    }

    @Override
    public long getColumnCount(RArray<?> rObject) {
        return 1L;
    }

    @Override
    protected String getLoadDataFName() {
        return "rj:::sda002.getDataVectorValues";
    }

    @Override
    protected String getSetDataFName() {
        return "rj:::sda002.setDataVectorValues";
    }

    @Override
    protected RVector<?> validateData(RObject rObject, RArray<?> referenceObject, LazyRStore.Fragment<RVector<?>> fragment) throws UnexpectedRDataException {
        RVector vector = RDataUtils.checkRVector((RObject)rObject);
        RDataUtils.checkLengthEqual((RObject)vector, (long)fragment.getRowCount());
        RDataUtils.checkData((RStore)rObject.getData(), (byte)referenceObject.getData().getStoreType());
        return vector;
    }

    @Override
    protected String getLoadRowNamesFName() {
        throw new UnsupportedOperationException();
    }

    public RVector<?> loadDimNames(FQRObjectRef ref, RArray<?> referenceObject, LazyRStore.Fragment<RVector<?>> fragment, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall fcall = r.createFunctionCall("rj:::sda002.getDataArrayDimNames");
        RArrayAsVectorDataAdapter.addXRef(fcall, ref);
        fcall.add("idxs", (RObject)R_OBJECT_FACTORY.createNumVector(new double[]{fragment.getRowBeginIdx() + 1L, fragment.getRowEndIdx()}));
        RObject fragmentObject = fcall.evalData(m);
        return this.validateRowNames(fragmentObject, referenceObject, fragment);
    }

    public RVector<?> loadDimItemNames(FQRObjectRef ref, RArray<?> referenceObject, int dim, LazyRStore.Fragment<RVector<?>> fragment, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall fcall = r.createFunctionCall("rj:::sda002.getDataArrayDimItemNames");
        RArrayAsVectorDataAdapter.addXRef(fcall, ref);
        fcall.addInt("dimIdx", dim + 1);
        fcall.add("idxs", (RObject)R_OBJECT_FACTORY.createNumVector(new double[]{fragment.getRowBeginIdx() + 1L, fragment.getRowEndIdx()}));
        RObject fragmentObject = fcall.evalData(m);
        return this.validateRowNames(fragmentObject, referenceObject, fragment);
    }
}

