/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RCharacterFix64Store;

public class RListFix64Impl
extends AbstractRObject
implements RList,
ExternalizableRObject {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    private final RObject[][] components;
    private final String className1;
    private final RCharacterStore namesAttribute;

    public RListFix64Impl(RObject[][] initialComponents, String[][] initialNames) {
        this(initialComponents, "list", initialNames);
    }

    public RListFix64Impl(RObject[][] initialComponents, String className1, @Nullable String @Nullable [][] initialNames) {
        this.length = RListFix64Impl.check2dArrayLength(initialComponents, 0x10000000);
        this.components = initialComponents;
        this.className1 = className1;
        if (initialNames != null) {
            this.namesAttribute = new RCharacterFix64Store(initialNames);
            if (this.namesAttribute.getLength() != this.length) {
                throw new IllegalArgumentException("Different length of components and names.");
            }
        } else {
            this.namesAttribute = null;
        }
    }

    public RListFix64Impl(RObject[][] initialComponents, RCharacter32Store initialNames) {
        this.components = initialComponents;
        this.length = this.components.length;
        this.className1 = "list";
        this.namesAttribute = initialNames;
    }

    public RListFix64Impl(long length, String className1) {
        this.length = length;
        this.className1 = className1;
        this.components = null;
        this.namesAttribute = null;
    }

    public RListFix64Impl(RJIO io, RObjectFactory factory, int options) throws IOException {
        this.className1 = (options & 0x10) != 0 ? io.readString() : (this.getRObjectType() == 6 ? "data.frame" : "list");
        long l = this.length = io.readVULong((byte)(options & 7));
        if ((options & 0x20) != 0) {
            this.namesAttribute = null;
            this.components = null;
        } else {
            this.namesAttribute = (RCharacterStore)factory.readNames(io, l);
            this.components = RListFix64Impl.new2dRObjectArray(options, 0x10000000);
            int i = 0;
            while (i < this.components.length) {
                RObject[] segment = this.components[i];
                int j = 0;
                while (j < segment.length) {
                    segment[j] = factory.readObject(io);
                    ++j;
                }
                ++i;
            }
        }
        if ((options & 8) != 0) {
            this.setAttributes(factory.readAttributeList(io));
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        this.doWriteExternal(io, 0, factory);
    }

    protected final void doWriteExternal(RJIO io, int options, RObjectFactory factory) throws IOException {
        RList attributes;
        long l = this.length;
        options |= io.getVULongGrade(l);
        if (!this.className1.equals(this.getDefaultRClassName())) {
            options |= 0x10;
        }
        RList rList = attributes = (io.flags & 2) != 0 ? this.getAttributes() : null;
        if (attributes != null) {
            options |= 8;
        }
        if (this.components == null) {
            options |= 0x20;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), l);
        if ((options & 0x20) == 0) {
            factory.writeNames(this.namesAttribute, io);
            int i = 0;
            while (i < this.components.length) {
                RObject[] segment = this.components[i];
                int j = 0;
                while (j < segment.length) {
                    factory.writeObject(segment[j], io);
                    ++j;
                }
                ++i;
            }
        }
        if (attributes != null) {
            factory.writeAttributeList(attributes, io);
        }
    }

    @Override
    public byte getRObjectType() {
        return 7;
    }

    protected String getDefaultRClassName() {
        return "list";
    }

    @Override
    public final String getRClassName() {
        return this.className1;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public final RCharacterStore getNames() {
        return this.namesAttribute;
    }

    @Override
    public final String getName(int idx) {
        if (this.namesAttribute != null) {
            return this.namesAttribute.getChar(idx);
        }
        return null;
    }

    @Override
    public final String getName(long idx) {
        if (this.namesAttribute != null) {
            return this.namesAttribute.getChar(idx);
        }
        return null;
    }

    @Override
    public final RObject get(int idx) {
        return this.components[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public final RObject get(long idx) {
        return this.components[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public final RObject get(String name) {
        long idx;
        if (this.namesAttribute != null && (idx = this.namesAttribute.indexOf(name)) >= 0L) {
            return this.get(idx);
        }
        return null;
    }

    @Override
    public final RStore<?> getData() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=RList, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.length);
        if (this.components != null) {
            sb.append("\n\tdata: ");
            int i = 0;
            while ((long)i < this.length) {
                if (i > 100) {
                    sb.append("\n... ");
                    break;
                }
                if (this.namesAttribute == null || this.namesAttribute.isNA(i)) {
                    sb.append("\n[[").append(i + 1).append("]]\n");
                } else {
                    sb.append("\n$").append(this.namesAttribute.getChar(i)).append("\n");
                }
                sb.append(this.components[i]);
                ++i;
            }
        } else {
            sb.append("\n<NODATA/>");
        }
        return sb.toString();
    }
}

