/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.core.source;

import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.r.core.source.doc.RPartitionNodeScanner;
import org.eclipse.statet.r.core.source.doc.RPartitionNodeType;

public abstract class AbstractRChunkPartitionNodeScanner
extends RPartitionNodeScanner {
    private static final int S_CHUNKCONTROL = 8;
    private static final int S_CHUNKCOMMENT = 9;
    public static final RPartitionNodeType R_CHUNK_BASE_TYPE = new RPartitionNodeType(){

        public String getPartitionType() {
            return "RweaveChunk.Base";
        }

        public byte getScannerState() {
            return 8;
        }
    };
    public static final RPartitionNodeType R_CHUNK_CONTROL_TYPE = new RPartitionNodeType(){

        public String getPartitionType() {
            return "RweaveChunk.Control";
        }

        public byte getScannerState() {
            return 8;
        }

        public boolean prefereAtBegin(TreePartitionNode node, IDocument document) {
            return true;
        }

        public boolean prefereAtEnd(TreePartitionNode node, IDocument document) {
            return true;
        }
    };
    public static final RPartitionNodeType R_CHUNK_COMMENT_TYPE = new RPartitionNodeType.Comment(){

        public String getPartitionType() {
            return "RweaveChunk.Comment";
        }

        public byte getScannerState() {
            return 9;
        }

        public boolean prefereAtBegin(TreePartitionNode node, IDocument document) {
            return true;
        }
    };
    protected static final byte NONE = 0;
    protected static final byte START_LINE = 1;
    protected static final byte REF_LINE = 2;
    protected static final byte STOP_LINE = 3;
    private TreePartitionNode chunkNode;
    private byte chunkLine;

    protected void init() {
        this.chunkNode = null;
        super.init();
        TreePartitionNode rootNode = this.getRootNode();
        if (rootNode.getType().getPartitionType() == "RweaveChunk.Base") {
            this.chunkNode = rootNode;
        }
        this.chunkLine = 0;
    }

    protected final TreePartitionNode getChunkNode() {
        return this.chunkNode;
    }

    protected final byte getChunkLine() {
        return this.chunkLine;
    }

    protected final void exitToChunkBase(byte chunkLine, int offset) {
        this.exitNodesTo(this.chunkNode, offset, 256);
        this.chunkLine = chunkLine;
    }

    protected abstract void handleNewLine(RPartitionNodeType var1);

    protected void handleEOF(RPartitionNodeType type) {
        TreePartitionNode rootNode = this.getRootNode();
        int offset = this.reader.getOffset();
        this.exitNodesTo(rootNode, offset, 256);
        this.getScan().expand(rootNode, offset, this.chunkLine == 3 ? 0 : 256, true);
    }

    protected void processExt(RPartitionNodeType type) {
        if (this.chunkNode != null) {
            switch (type.getScannerState()) {
                case 8: {
                    this.processChunkControlOpen(this.chunkLine);
                    return;
                }
                case 9: {
                    this.processChunkComment();
                    return;
                }
            }
        }
        super.processExt(type);
    }

    protected abstract void processChunkControlOpen(byte var1);

    protected void processChunkComment() {
        while (true) {
            switch (this.reader.read()) {
                case -1: {
                    this.last = 1;
                    return;
                }
                case 13: {
                    this.reader.read('\n');
                }
                case 10: {
                    this.exitNode(this.reader.getOffset(), 0);
                    if (this.chunkLine == 3) {
                        this.last = 1;
                        return;
                    }
                    this.addNode(this.getDefaultRootType(), this.reader.getOffset());
                    this.last = (byte)2;
                    return;
                }
            }
        }
    }
}

