/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pager;

import java.util.ArrayList;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class TextFileParser {
    public static final String DEFAULT_FORMAT_TYPE = "__dftl_partition_content_type";
    public static final String UNDERLINE_FORMAT_TYPE = "Pager.Underline";
    private boolean createDefaultRegions = false;
    private final StringBuilder cleanTextBuilder = new StringBuilder();
    private final ArrayList<ITypedRegion> formatRegions = new ArrayList();
    private String cleanText = "";

    public void setCreateDefaultRegions(boolean enable) {
        this.createDefaultRegions = enable;
    }

    public void parse(String in) {
        this.formatRegions.clear();
        this.cleanTextBuilder.setLength(0);
        int inLength = in.length();
        int offsetDone = 0;
        while (offsetDone < inLength) {
            int backOffset = in.indexOf(8, offsetDone);
            if (backOffset >= 0) {
                this.cleanTextBuilder.append(in, offsetDone, backOffset - 1);
                if (backOffset + 1 == inLength || backOffset == offsetDone) {
                    offsetDone = backOffset + 1;
                    continue;
                }
                switch (in.charAt(backOffset - 1)) {
                    case '_': {
                        this.checkDefaultFormat(this.cleanTextBuilder.length());
                        offsetDone = this.readBackspaceFormat(in, backOffset - 1, '_', UNDERLINE_FORMAT_TYPE);
                        break;
                    }
                    default: {
                        offsetDone = backOffset + 1;
                        break;
                    }
                }
                continue;
            }
            if (offsetDone <= 0) break;
            this.cleanTextBuilder.append(in, offsetDone, inLength);
            offsetDone = inLength;
            break;
        }
        this.cleanText = offsetDone > 0 ? this.cleanTextBuilder.toString() : in;
        this.checkDefaultFormat(this.cleanText.length());
    }

    private void checkDefaultFormat(int offset) {
        int lastEndOffset;
        if (!this.createDefaultRegions) {
            return;
        }
        if (this.formatRegions.isEmpty()) {
            lastEndOffset = 0;
        } else {
            ITypedRegion lastFormat = this.formatRegions.getLast();
            lastEndOffset = lastFormat.getOffset() + lastFormat.getLength();
        }
        if (offset > lastEndOffset) {
            this.formatRegions.add((ITypedRegion)new TypedRegion(lastEndOffset, offset - lastEndOffset, DEFAULT_FORMAT_TYPE));
        }
    }

    private int readBackspaceFormat(String in, int offset, char formatChar, String formatType) {
        int inLength = in.length();
        int cleanStartOffset = this.cleanTextBuilder.length();
        do {
            this.cleanTextBuilder.append(in.charAt(offset + 2));
        } while ((offset += 3) + 2 < inLength && in.charAt(offset) == formatChar && in.charAt(offset + 1) == '\b');
        this.formatRegions.add((ITypedRegion)new TypedRegion(cleanStartOffset, this.cleanTextBuilder.length() - cleanStartOffset, formatType));
        return offset;
    }

    public String getCleanText() {
        return this.cleanText;
    }

    public ImList<ITypedRegion> getFormatRegions() {
        return ImCollections.toList(this.formatRegions);
    }
}

