/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model.build;

import java.util.List;
import org.eclipse.statet.internal.r.core.rmodel.RAstProblemReporter;
import org.eclipse.statet.internal.r.core.rmodel.RTaskTagReporter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.model.core.build.BasicIssueReporter;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.rlang.RCompositeSrcStrElement;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.source.ast.RAstNode;

@NonNullByDefault
public class RIssueReporter
extends BasicIssueReporter<RSourceUnit, RSourceUnitModelInfo> {
    private final RAstProblemReporter syntaxProblemReporter = new RAstProblemReporter();
    private final RTaskTagReporter taskReporter = new RTaskTagReporter();

    public RIssueReporter() {
        super("R");
    }

    protected RTaskTagReporter getTaskReporter() {
        return this.taskReporter;
    }

    public void configure(TaskIssueConfig taskIssueConfig) {
        super.configure(taskIssueConfig);
    }

    protected void runReporters(RSourceUnit sourceUnit, RSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        RLangSrcStrElement element = modelInfo.getSourceElement();
        if (element instanceof RCompositeSrcStrElement) {
            List<? extends RLangSrcStrElement> elements = ((RCompositeSrcStrElement)element).getCompositeElements();
            for (RLangSrcStrElement rLangSrcStrElement : elements) {
                this.runReporters(sourceUnit, (AstNode)rLangSrcStrElement.getAdapter(AstNode.class), modelInfo, content, requestor, level);
            }
        } else {
            this.runReporters(sourceUnit, (AstNode)element.getAdapter(AstNode.class), modelInfo, content, requestor, level);
        }
    }

    public void run(RAstNode node, SourceContent content, IssueRequestor requestor, int level) {
        if (requestor.isInterestedInProblems("R")) {
            this.syntaxProblemReporter.run(node, content, requestor);
        }
    }

    protected void runReporters(RSourceUnit sourceUnit, @Nullable AstNode node, @Nullable RSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (node == null) {
            return;
        }
        if (node instanceof RAstNode) {
            this.runReporters(sourceUnit, (RAstNode)node, modelInfo, content, requestor, level);
        } else {
            int n = node.getChildCount();
            int i = 0;
            while (i < n) {
                AstNode child = node.getChild(i);
                if (child instanceof RAstNode) {
                    this.runReporters(sourceUnit, (RAstNode)child, modelInfo, content, requestor, level);
                }
                ++i;
            }
        }
    }

    private void runReporters(RSourceUnit sourceUnit, RAstNode node, @Nullable RSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        if (this.shouldReportProblems()) {
            this.syntaxProblemReporter.run(node, content, requestor);
        }
        if (this.shouldReportTasks()) {
            this.taskReporter.run(sourceUnit, node, content, requestor);
        }
    }
}

