/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.core.builder.CompositeFrame;
import org.eclipse.statet.internal.r.core.builder.ExportedRClass;
import org.eclipse.statet.internal.r.core.builder.ExportedRElement;
import org.eclipse.statet.internal.r.core.builder.ExportedRMethod;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.io.DataStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RLangSrcElement;

@NonNullByDefault
public class RUnitElement
implements RLangSrcElement<RLangSrcElement<?>> {
    private final SourceUnit sourceUnit;
    CompositeFrame envir;
    private final List<ExportedRElement> elements;

    public static RUnitElement read(RSourceUnit su, CompositeFrame envir, InputStream input) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataStream in = DataStream.get((InputStream)input);){
            if (in.readVersion() != 1) {
                throw new IOException("Unsupported data version, please rebuild the index (clean workspace).");
            }
            RUnitElement element = new RUnitElement(su, envir, in);
            if (input.available() != 0) {
                throw new IOException(String.format("Invalid data: next= %1$02X.", input.read()));
            }
            return element;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RUnitElement(RSourceUnit su, List<ExportedRElement> children) {
        this.sourceUnit = su;
        this.elements = Collections.unmodifiableList(children);
    }

    private RUnitElement(RSourceUnit su, CompositeFrame envir, DataStream in) throws IOException {
        this.sourceUnit = su;
        this.envir = envir;
        Object[] array = new ExportedRElement[in.readInt()];
        int i = 0;
        while (i < array.length) {
            byte o = in.readByte();
            array[i] = switch (o & 0xF) {
                case 0 -> new ExportedRElement(this, in, o);
                case 1 -> new ExportedRClass(this, in, o);
                case 2 -> new ExportedRMethod(this, in, o);
                default -> throw new IOException(String.format("Invalid data: o= %1$02X.", o));
            };
            ++i;
        }
        this.elements = ImCollections.newList((Object[])array);
    }

    public void save(OutputStream output) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataStream out = DataStream.get((OutputStream)output);){
            out.writeVersion(1);
            int l = this.elements.size();
            out.writeInt(l);
            int i = 0;
            while (i < l) {
                this.elements.get(i).writeTo(out, (byte)0);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 528;
    }

    @Override
    public RElementName getElementName() {
        ElementName elementName = this.sourceUnit.getElementName();
        if (elementName instanceof RElementName) {
            return (RElementName)elementName;
        }
        return RElementName.create(2, elementName.getSegmentName());
    }

    public String getId() {
        return this.sourceUnit.getId();
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return this.sourceUnit.isReadOnly();
    }

    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public @Nullable RLangSrcElement<?> getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSrcElement<?>> filter) {
        return LtkModelUtils.hasChildren(this.elements, filter);
    }

    @Override
    public List<? extends RLangSrcElement<?>> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSrcElement<?>> filter) {
        return LtkModelUtils.getChildren(this.elements, filter);
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public @Nullable TextRegion getSourceRange() {
        return null;
    }

    public @Nullable TextRegion getNameSourceRange() {
        return null;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }
}

