/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.statet.internal.r.core.builder.RUnitElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RLangSrcElement;
import org.eclipse.statet.r.core.model.rlang.RSrcFrame;

@NonNullByDefault
public class CompositeFrame
implements RSrcFrame<RLangSrcElement<?>> {
    private final int frameType;
    private final RElementName elementName;
    public final Map<String, RUnitElement> modelElements;
    private final Lock lock;

    public CompositeFrame(ReadWriteLock lock, @Nullable String packageName, String projectName, @Nullable Map<String, RUnitElement> elements) {
        this.lock = lock.readLock();
        HashMap hashMap = this.modelElements = elements != null ? elements : new HashMap();
        if (packageName != null) {
            this.frameType = 2;
            this.elementName = RElementName.create(38, packageName);
        } else {
            this.frameType = 1;
            this.elementName = RElementName.create(41, projectName);
        }
    }

    public CompositeFrame(ReadWriteLock lock, @Nullable String packageName, String projectName, CompositeFrame copyFrom) {
        this(lock, packageName, projectName, copyFrom.modelElements);
    }

    public CompositeFrame(ReadWriteLock lock, @Nullable String packageName, String projectName) {
        this(lock, packageName, projectName, (Map<String, RUnitElement>)null);
    }

    @Override
    public int getFrameType() {
        return this.frameType;
    }

    @Override
    public @Nullable String getFrameId() {
        return null;
    }

    @Override
    public RElementName getElementName() {
        return this.elementName;
    }

    @Override
    public List<? extends RLangSrcElement<?>> getModelElements() {
        this.lock.lock();
        try {
            Collection<RUnitElement> values = this.modelElements.values();
            ArrayList<RUnitElement> list = new ArrayList<RUnitElement>(values.size());
            list.addAll(values);
            ArrayList<RUnitElement> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSrcElement<?>> filter) {
        this.lock.lock();
        try {
            if (this.modelElements.isEmpty()) {
                return false;
            }
            for (RUnitElement element : this.modelElements.values()) {
                if (!element.hasModelChildren(filter)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<? extends RLangSrcElement<?>> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSrcElement<?>> filter) {
        this.lock.lock();
        try {
            if (this.modelElements.isEmpty()) {
                ImList imList = ImCollections.emptyList();
                return imList;
            }
            ArrayList children = new ArrayList();
            for (RUnitElement element : this.modelElements.values()) {
                List<RLangSrcElement<?>> elementChildren = element.getModelChildren((LtkModelElementFilter<? super RLangSrcElement<?>>)null);
                if (elementChildren.isEmpty()) continue;
                children.ensureCapacity(children.size() + elementChildren.size());
                for (RLangSrcElement<?> child : elementChildren) {
                    if (filter != null && !filter.include(child)) continue;
                    children.add(child);
                }
            }
            ArrayList arrayList = children;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<? extends RFrame<?>> getPotentialParents() {
        return ImCollections.emptyList();
    }

    public @Nullable RUnitElement setModelElement(String suId, RUnitElement element) {
        element.envir = this;
        return this.modelElements.put(suId, element);
    }

    public @Nullable RUnitElement removeModelElement(String suId) {
        return this.modelElements.remove(suId);
    }

    public void removeModelElements(String modelTypeId) {
        Iterator<RUnitElement> iter = this.modelElements.values().iterator();
        while (iter.hasNext()) {
            RUnitElement unitElement = iter.next();
            if (unitElement.getModelTypeId() != modelTypeId) continue;
            iter.remove();
        }
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder("CompositeFrame", this.getClass());
        sb.addPropFormat("frameType", "0x%02X", new Object[]{this.frameType});
        sb.addProp("elementName", (Object)this.elementName);
        return sb.build();
    }
}

