/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.List;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ltk.ui.TemplatesMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.templates.TemplatePreview;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.text.templates.ContextTypeRegistry;

public class TemplateSelectionComposite
extends Composite
implements ISelectionChangedListener {
    private static final Template NONE = new Template("none", "None", "", "", false);
    private ContextTypeRegistry contextRegistry;
    private ImList<Template> templates;
    private SourceEditorViewerConfigurator viewerConfigurator;
    private TableViewer tableViewer;
    private TemplatePreview preview;
    private Template selectedTemplate;

    public TemplateSelectionComposite(Composite parent) {
        super(parent, 0);
        this.createControls();
    }

    public TableViewer getSelectionViewer() {
        return this.tableViewer;
    }

    public TemplatePreview getPreview() {
        return this.preview;
    }

    public void setConfigurator(SourceEditorViewerConfigurator patternConfigurator) {
        this.viewerConfigurator = patternConfigurator;
    }

    public void setInput(List<Template> templates, boolean allowNone, ContextTypeRegistry contextRegistry) {
        this.templates = allowNone ? ImCollections.addElement(templates, (int)0, (Object)NONE) : ImCollections.toList(templates);
        this.contextRegistry = contextRegistry;
        this.tableViewer.setInput(this.templates);
    }

    public void setSelection(String name) {
        if (name != null) {
            for (Template template : this.templates) {
                if (!template.getName().equals(name)) continue;
                this.setSelection(template);
                return;
            }
        }
        this.setSelection(NONE);
    }

    public void setSelection(Template template) {
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
        this.updateSourceViewerInput();
    }

    protected void createControls() {
        this.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Control control = this.createTableViewer(this);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.preview = new TemplatePreview();
        Label label = new Label((Composite)this, 16384);
        label.setText(TemplatesMessages.Preview_label + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SourceViewer viewer = this.preview.createSourceViewer(this);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = new PixelConverter(viewer.getControl()).convertHeightInCharsToPixels(5);
        viewer.getControl().setLayoutData((Object)gd);
    }

    protected Control createTableViewer(Composite parent) {
        ViewerUtils.TableComposite tableComposite = new ViewerUtils.TableComposite(parent, 67588);
        tableComposite.addColumn("Name", 16384, (ColumnLayoutData)new ColumnWeightData(100));
        TableViewer viewer = tableComposite.viewer;
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configureViewer(viewer);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tableViewer = viewer;
        return tableComposite;
    }

    protected void configureViewer(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Template)element).getDescription();
            }
        });
    }

    protected void updateSourceViewerInput() {
        Template template = this.selectedTemplate;
        this.preview.updateSourceViewerInput(template, this.contextRegistry, this.viewerConfigurator);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Template template = (Template)((IStructuredSelection)event.getSelection()).getFirstElement();
        this.selectedTemplate = template != NONE ? template : null;
        this.updateSourceViewerInput();
    }

    public Template getSelectedTemplate() {
        return this.selectedTemplate;
    }
}

