/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.net.URI;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.model.core.DocumentModelProvider;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

@NonNullByDefault
public class SourceDocumentProvider<T extends SourceUnit>
extends TextFileDocumentProvider
implements DocumentModelProvider,
SourceUnitIssueSupport {
    private final String modelTypeId;
    private final @Nullable PartitionerDocumentSetupParticipant documentSetupParticipant;
    private final IssueTypeSet issueTypeSet;

    public SourceDocumentProvider(String modelTypeId, @Nullable PartitionerDocumentSetupParticipant documentSetupParticipant, IssueTypeSet issueTypeSet) {
        this.modelTypeId = (String)ObjectUtils.nonNullAssert((Object)modelTypeId);
        this.documentSetupParticipant = documentSetupParticipant;
        this.issueTypeSet = issueTypeSet;
        TextFileDocumentProvider parent = new TextFileDocumentProvider();
        if (documentSetupParticipant != null) {
            parent = new ForwardingDocumentProvider(documentSetupParticipant.getPartitioningId(), (IDocumentSetupParticipant)documentSetupParticipant, (IDocumentProvider)parent);
        }
        this.setParentDocumentProvider((IDocumentProvider)parent);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceFileInfo();
    }

    public void disconnect(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof SourceFileInfo) {
            SourceFileInfo rinfo = (SourceFileInfo)info;
            if (rinfo.fCount == 1 && rinfo.workingCopy != null) {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor(), (int)1);
                try {
                    rinfo.workingCopy.disconnect((IProgressMonitor)m.newChild(1));
                }
                finally {
                    rinfo.workingCopy = null;
                    m.done();
                }
            }
        }
        super.disconnect(element);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        SourceFileInfo sourceInfo;
        block13: {
            TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
            if (!(info instanceof SourceFileInfo)) {
                return null;
            }
            sourceInfo = (SourceFileInfo)info;
            IDocument document = this.getDocument(element);
            if (document instanceof AbstractDocument) {
                this.setupDocument((AbstractDocument)document);
            }
            SourceUnitManager suManager = LtkModels.getSourceUnitManager();
            SubMonitor m = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor());
            SourceUnit pUnit = null;
            try {
                IFileStore store;
                IFile ifile;
                IFile iFile = ifile = element instanceof IAdaptable ? (IFile)((IAdaptable)element).getAdapter(IFile.class) : null;
                if (ifile != null) {
                    m.setWorkRemaining(2);
                    pUnit = suManager.getSourceUnit(this.modelTypeId, Ltk.PERSISTENCE_CONTEXT, (Object)ifile, (IProgressMonitor)m.newChild(1));
                    sourceInfo.workingCopy = suManager.getSourceUnit(Ltk.EDITOR_CONTEXT, pUnit, false, (IProgressMonitor)m.newChild(1));
                    break block13;
                }
                if (!(element instanceof IURIEditorInput)) break block13;
                m.setWorkRemaining(1);
                try {
                    store = EFS.getStore((URI)((IURIEditorInput)element).getURI());
                }
                catch (CoreException e) {
                    SourceFileInfo sourceFileInfo = sourceInfo;
                    if (pUnit != null) {
                        pUnit.disconnect((IProgressMonitor)m);
                    }
                    m.done();
                    return sourceFileInfo;
                }
                try {
                    sourceInfo.workingCopy = suManager.getSourceUnit(this.modelTypeId, Ltk.EDITOR_CONTEXT, (Object)store, (IProgressMonitor)m.newChild(1));
                }
                catch (StatusException e) {
                    throw EStatusUtils.convert((StatusException)e);
                }
            }
            finally {
                if (pUnit != null) {
                    pUnit.disconnect((IProgressMonitor)m);
                }
                m.done();
            }
        }
        return sourceInfo;
    }

    protected void setupDocument(AbstractDocument document) {
        if (this.documentSetupParticipant != null) {
            this.documentSetupParticipant.setup((IDocument)document);
        }
    }

    public @Nullable T getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof SourceFileInfo) {
            return (T)((SourceFileInfo)fileInfo).workingCopy;
        }
        return null;
    }

    public @Nullable IAnnotationModel getAnnotationModel(@Nullable Object element) {
        if (element instanceof WorkspaceSourceUnit) {
            element = new FileEditorInput((IFile)((WorkspaceSourceUnit)element).getResource());
        }
        return super.getAnnotationModel(element);
    }

    protected @Nullable IAnnotationModel createAnnotationModel(IFile file) {
        return new SourceAnnotationModel((IResource)file, this.getIssueTypeSet());
    }

    public IssueTypeSet getIssueTypeSet() {
        return this.issueTypeSet;
    }

    public void clearIssues(SourceUnit sourceUnit) throws CoreException {
    }

    public @Nullable IssueRequestor createIssueRequestor(SourceUnit sourceUnit) {
        IAnnotationModel annotationModel = this.getAnnotationModel(sourceUnit);
        if (annotationModel instanceof SourceAnnotationModel) {
            return ((SourceAnnotationModel)annotationModel).createIssueRequestor();
        }
        return null;
    }

    public static class SourceFileInfo
    extends TextFileDocumentProvider.FileInfo {
        private @Nullable SourceUnit workingCopy;
    }
}

