/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.settings;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.text.ui.presentation.BasicTextStyleManager;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class PreferenceStoreTextStyleManager<TAttributes>
extends BasicTextStyleManager<TAttributes>
implements SettingsChangeNotifier.ManageListener {
    protected final IPreferenceStore preferenceStore;
    private final String stylesGroupId;

    public PreferenceStoreTextStyleManager(IPreferenceStore preferenceStore, String stylesGroupId) {
        this.preferenceStore = preferenceStore;
        this.stylesGroupId = stylesGroupId;
    }

    protected String resolveUsedKey(String key) {
        String use = key;
        String test;
        while ((test = this.preferenceStore.getString(use + ".use")) != null && !test.equals("") && !test.equals(use)) {
            use = test;
        }
        return use;
    }

    @Override
    protected abstract TAttributes createStyleData(String var1);

    public boolean affectsTextPresentation(Set<String> groupIds) {
        return groupIds.contains(this.stylesGroupId);
    }

    public void handleSettingsChanged(Set<String> groupIds, @Nullable Map<String, Object> options) {
        if (this.affectsTextPresentation(groupIds)) {
            this.updateTextStyles();
            if (options != null) {
                options.put("affects.Presentation", Boolean.TRUE);
            }
        }
    }

    public void beforeSettingsChangeNotification(final Set<String> groupIds) {
        if (this.affectsTextPresentation(groupIds)) {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceStoreTextStyleManager.this.handleSettingsChanged(groupIds, null);
                }
            });
        }
    }

    public void afterSettingsChangeNotification(Set<String> groupIds) {
    }
}

