/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.presentation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public abstract class BasicTextStyleManager<TStyleData>
implements TextStyleManager<TStyleData> {
    private final Map<String, BasicTextStyleToken<TStyleData>> tokenMap = new HashMap<String, BasicTextStyleToken<TStyleData>>();

    @Override
    public TextStyleManager.TextStyleToken<TStyleData> getToken(String key) {
        BasicTextStyleToken<TStyleData> token = this.tokenMap.get(key);
        if (token == null) {
            token = new BasicTextStyleToken<TStyleData>(this.createStyleData(key));
            this.tokenMap.put(key, token);
        }
        return token;
    }

    protected abstract TStyleData createStyleData(String var1);

    protected void updateTextStyles() {
        for (Map.Entry<String, BasicTextStyleToken<TStyleData>> token : this.tokenMap.entrySet()) {
            token.getValue().setData(this.createStyleData(token.getKey()));
        }
    }

    protected static class BasicTextStyleToken<TStyleData>
    implements TextStyleManager.TextStyleToken<TStyleData> {
        private TStyleData data;

        public BasicTextStyleToken(TStyleData data) {
            this.data = data;
        }

        protected void setData(TStyleData data) {
            this.data = data;
        }

        public boolean isUndefined() {
            return false;
        }

        public boolean isWhitespace() {
            return false;
        }

        public boolean isEOF() {
            return false;
        }

        public boolean isOther() {
            return false;
        }

        @Override
        public TStyleData getData() {
            return this.data;
        }

        public String toString() {
            ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(TextStyleManager.TextStyleToken.class, this.getClass());
            sb.addProp("special");
            if (this.isUndefined()) {
                sb.append("undefined ");
            }
            if (this.isWhitespace()) {
                sb.append("whitespace ");
            }
            if (this.isEOF()) {
                sb.append("eof ");
            }
            if (this.isOther()) {
                sb.append("other ");
            }
            sb.addProp("data", this.getData());
            return sb.toString();
        }
    }
}

