/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.List;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

@NonNullByDefault
public class TextChangeCompatibility {
    public static void addTextEdits(TextChange change, String name, List<TextEdit> edits, boolean enable) throws MalformedTreeException {
        switch (edits.size()) {
            case 0: {
                return;
            }
            case 1: {
                TextChangeCompatibility.addTextEdit1(change, name, edits.get(0), enable);
                return;
            }
        }
        TextChangeCompatibility.addTextEdits1(change, name, edits.toArray(new TextEdit[edits.size()]), enable);
    }

    public static void addTextEdits(TextChange change, String name, List<TextEdit> edits) throws MalformedTreeException {
        switch (edits.size()) {
            case 0: {
                return;
            }
            case 1: {
                TextChangeCompatibility.addTextEdit1(change, name, edits.get(0), true);
                return;
            }
        }
        TextChangeCompatibility.addTextEdits1(change, name, edits.toArray(new TextEdit[edits.size()]), true);
    }

    public static void addTextEdit(TextChange change, String name, TextEdit edit, boolean enable) throws MalformedTreeException {
        TextChangeCompatibility.addTextEdit1(change, name, edit, enable);
    }

    public static void addTextEdit(TextChange change, String name, TextEdit edit) throws MalformedTreeException {
        TextChangeCompatibility.addTextEdit1(change, name, edit, true);
    }

    private static void addTextEdits1(TextChange change, String name, @NonNull TextEdit[] edits, boolean enable) throws MalformedTreeException {
        TextEdit root = TextChangeCompatibility.getRoot(change);
        int i = 0;
        while (i < edits.length) {
            TextChangeCompatibility.insert(root, edits[i]);
            ++i;
        }
        TextEditGroup group = new TextEditGroup(name, edits);
        TextEditChangeGroup changeGroup = new TextEditChangeGroup(change, group);
        changeGroup.setEnabled(enable);
        change.addTextEditChangeGroup(changeGroup);
    }

    private static void addTextEdit1(TextChange change, String name, TextEdit edit, boolean enable) throws MalformedTreeException {
        TextChangeCompatibility.insert(TextChangeCompatibility.getRoot(change), edit);
        TextEditGroup group = new TextEditGroup(name, edit);
        TextEditChangeGroup changeGroup = new TextEditChangeGroup(change, group);
        changeGroup.setEnabled(enable);
        change.addTextEditChangeGroup(changeGroup);
    }

    public static void addTextEdit(TextChange change, String name, TextEdit edit, GroupCategorySet groupCategories) throws MalformedTreeException {
        TextChangeCompatibility.insert(TextChangeCompatibility.getRoot(change), edit);
        CategorizedTextEditGroup group = new CategorizedTextEditGroup(name, edit, groupCategories);
        TextEditChangeGroup changeGroup = new TextEditChangeGroup(change, (TextEditGroup)group);
        change.addTextEditChangeGroup(changeGroup);
    }

    public static void addMarker(TextChange change, RangeMarker marker) throws MalformedTreeException {
        TextChangeCompatibility.insert(TextChangeCompatibility.getRoot(change), (TextEdit)marker);
    }

    public static void insert(TextEdit parent, TextEdit edit) throws MalformedTreeException {
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit child = children[i];
            if (TextChangeCompatibility.covers(child, edit)) {
                TextChangeCompatibility.insert(child, edit);
                return;
            }
            ++i;
        }
        int removed = 0;
        int i2 = 0;
        while (i2 < children.length) {
            TextEdit child = children[i2];
            if (TextChangeCompatibility.covers(edit, child)) {
                parent.removeChild(i2 - removed++);
                edit.addChild(child);
            }
            ++i2;
        }
        parent.addChild(edit);
    }

    private static TextEdit getRoot(TextChange change) {
        TextEdit root = change.getEdit();
        if (root == null) {
            root = new MultiTextEdit();
            change.setEdit(root);
        }
        return root;
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }
}

