/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.graphic.core;

import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.util.StringUtils;

@NonNullByDefault
public final class RGBColorDef
extends ColorDef {
    public static final RGBColorDef parseHex(String s) {
        if (s.length() != 6) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < 6) {
            if (s.charAt(i++) >= '0') continue;
            throw new IllegalArgumentException();
        }
        return new RGBColorDef(Integer.parseInt(s, 0, 2, 16), Integer.parseInt(s, 2, 4, 16), Integer.parseInt(s, 4, 6, 16));
    }

    public static final RGBColorDef parseDec(String s) {
        int sep1 = s.indexOf(44, 1);
        int sep2 = s.indexOf(44, sep1 + 2);
        if (sep1 == -1 || sep2 == -1) {
            throw new IllegalArgumentException();
        }
        return new RGBColorDef(Integer.parseInt(StringUtils.trim(s, 0, sep1), 10), Integer.parseInt(StringUtils.trim(s, sep1 + 1, sep2), 10), Integer.parseInt(StringUtils.trim(s, sep2 + 1, s.length()), 10));
    }

    public static final RGBColorDef toRGBColorDef(ColorDef colorDef) {
        return colorDef instanceof RGBColorDef ? (RGBColorDef)colorDef : new RGBColorDef(colorDef);
    }

    public RGBColorDef(int red, int green, int blue) {
        super(RGBColorDef.checkRGB(red, green, blue));
    }

    protected RGBColorDef(ColorDef def) {
        super(def);
    }

    @Override
    public String getType() {
        return "RGB";
    }
}

