/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ImEmptyList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonSpliterator;
import org.eclipse.statet.jcommons.collections.AbstractImCollection;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImSingletonList<E>
extends AbstractImList<E>
implements ImList<E>,
RandomAccess,
ImCollection.MappingResult<E> {
    private final E e0;

    public ImSingletonList(E e) {
        this.e0 = e;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object e) {
        return Objects.equals(this.e0, e);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e0;
    }

    @Override
    public E getFirst() {
        return this.e0;
    }

    @Override
    public E getLast() {
        return this.e0;
    }

    @Override
    public int indexOf(@Nullable Object e) {
        return Objects.equals(this.e0, e) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object e) {
        return Objects.equals(this.e0, e) ? 0 : -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Iter(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if ((index & 0xFFFFFFFE) != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return new Iter(index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ImSingletonSpliterator<E>(this.e0);
    }

    @Override
    public ImList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > 1) {
            throw new IndexOutOfBoundsException("fromIndex= " + fromIndex + ", toIndex= " + toIndex + ", size= 1");
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex: fromIndex= " + fromIndex + ", toIndex= " + toIndex);
        }
        if (toIndex - fromIndex == 1) {
            return this;
        }
        return ImEmptyList.INSTANCE;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.e0};
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length < 1) {
            dest = (Object[])Array.newInstance(dest.getClass().getComponentType(), 1);
        }
        dest[0] = this.e0;
        if (dest.length > 1) {
            dest[1] = null;
        }
        return dest;
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        T[] dest = generator.apply(1);
        dest[0] = this.e0;
        return dest;
    }

    @Override
    public void copyTo(int srcIndex, Object[] dest, int destIndex, int length) {
        assert (length == 1);
        dest[destIndex] = this.e0;
    }

    @Override
    public void copyTo(Object[] dest, int destIndex) {
        dest[destIndex] = this.e0;
    }

    @Override
    public ImList<E> toList() {
        return this;
    }

    @Override
    public ImIdentityList<E> toIdentityList() {
        return new ImSingletonIdentityList<E>(this.e0);
    }

    @Override
    public ImList<E> reversed() {
        return this;
    }

    @Override
    public <R> ImCollection.MappingResult<R> map(Function<E, R> mapper) {
        return new ImSingletonList<R>(mapper.apply(this.e0));
    }

    @Override
    public @Nullable E findFirst(Predicate<E> predicate) {
        return predicate.test(this.e0) ? (E)this.e0 : null;
    }

    @Override
    public boolean anyMatch(Predicate<? super E> predicate) {
        return predicate.test(this.e0);
    }

    @Override
    public boolean allMatch(Predicate<? super E> predicate) {
        return predicate.test(this.e0);
    }

    @Override
    public boolean noneMatch(Predicate<? super E> predicate) {
        return !predicate.test(this.e0);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.e0);
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List other = (List)obj;
            return 1 == other.size() && Objects.equals(this.e0, other.get(0));
        }
        return false;
    }

    public String toString() {
        return "[" + String.valueOf(this.e0) + "]";
    }

    private class Iter
    extends AbstractImCollection.AbstractImListIter<E> {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < 1;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (this.cursor >= 1) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ImSingletonList.this.e0;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return ImSingletonList.this.e0;
        }
    }
}

