/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ContentTypeConfig
extends AutoConfig {
    private final String contentTypeId;
    private @Nullable String label;

    public ContentTypeConfig(String contentTypeId, ImList<Task> tasks) {
        super("onFileContent:" + contentTypeId, tasks);
        this.contentTypeId = contentTypeId;
    }

    public String getContentTypeId() {
        return this.contentTypeId;
    }

    @Override
    public @Nullable String getLabel() {
        IContentType contentType;
        String label = this.label;
        if (label == null && (contentType = Platform.getContentTypeManager().getContentType(this.contentTypeId)) != null) {
            this.label = label = contentType.getName();
        }
        return label;
    }
}

