/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize.core;

import org.eclipse.statet.ecommons.waltable.core.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayer;
import org.eclipse.statet.ecommons.waltable.resize.core.DimPositionResizeCommand;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class PositionResizeCommandHandler
extends AbstractLayerCommandHandler<DimPositionResizeCommand> {
    private final DataLayer dataLayer;

    public PositionResizeCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<DimPositionResizeCommand> getCommandClass() {
        return DimPositionResizeCommand.class;
    }

    @Override
    protected boolean doCommand(DimPositionResizeCommand command) {
        if (command.getOrientation() == Orientation.HORIZONTAL) {
            this.dataLayer.setColumnWidthByPosition(command.getPosition(), command.getNewSize());
        } else {
            this.dataLayer.setRowHeightByPosition(command.getPosition(), command.getNewSize());
        }
        return true;
    }
}

