/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.input;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

@NonNullByDefault
public class DocumentParserInput
extends TextParserInput {
    private IDocument document;

    public DocumentParserInput(int defaultBufferSize) {
        super(defaultBufferSize);
    }

    public DocumentParserInput() {
        this(2048);
    }

    public DocumentParserInput(IDocument document) {
        this(Math.min(document.getLength(), 2048));
        this.document = document;
    }

    public DocumentParserInput reset(IDocument document) {
        if (document == null) {
            throw new NullPointerException("document");
        }
        this.document = document;
        super.reset();
        return this;
    }

    public IDocument getDocument() {
        return this.document;
    }

    protected int getSourceLength() {
        return this.document != null ? this.document.getLength() : 0;
    }

    protected String getSourceString() {
        return this.document != null ? this.document.get() : null;
    }

    protected void doUpdateBuffer(int index, char[] buffer, int requiredLength, int recommendLength) {
        try {
            int length = Math.min(recommendLength, this.getStopIndex() - index);
            int reused = this.copyBuffer0(buffer);
            if (length > reused) {
                int l = length - reused;
                this.document.get(index + reused, l).getChars(0, l, buffer, reused);
            }
            this.setBuffer(buffer, 0, length);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

