/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.io.internal.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class EFSUtilImpl
extends FileUtil {
    private static final String LABEL_2_LOCALFILE = "' (" + Messages.FileType_Local_name + ")";
    private final IFileStore file;

    public EFSUtilImpl(IFileStore file) {
        this.file = file;
    }

    @Override
    public String getLabel() {
        IFileSystem system = this.file.getFileSystem();
        if (system.equals(EFS.getLocalFileSystem())) {
            return "'" + this.file.toString() + LABEL_2_LOCALFILE;
        }
        return "'" + this.file.toURI().toString() + "'";
    }

    @Override
    public URI getURI() {
        return this.file.toURI();
    }

    @Override
    public long getTimeStamp(IProgressMonitor monitor) throws CoreException {
        return this.file.fetchInfo(0, monitor).getLastModified();
    }

    @Override
    public FileUtil.ReadTextFileOperation createReadTextFileOp(final FileUtil.ReaderAction action) {
        return new FileUtil.ReadTextFileOperation(this){

            @Override
            protected FileUtil.FileInput getInput(IProgressMonitor monitor) throws CoreException, IOException {
                try {
                    InputStream raw = EFSUtilImpl.this.file.openInputStream(0, monitor);
                    FileUtil.FileInput fileInput = new FileUtil.FileInput(raw, null);
                    return fileInput;
                }
                finally {
                    monitor.done();
                }
            }

            @Override
            protected FileUtil.ReaderAction getAction() {
                return action;
            }
        };
    }

    @Override
    public FileUtil.WriteTextFileOperation createWriteTextFileOp(final String content) {
        return new FileUtil.WriteTextFileOperation(this){

            @Override
            protected void writeImpl(SubMonitor m) throws CoreException, IOException {
                block18: {
                    boolean exists = EFSUtilImpl.this.file.fetchInfo(0, (IProgressMonitor)m.newChild(5)).exists();
                    if (exists && (this.mode & 3) == 0) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, NLS.bind((String)Messages.Resource_error_AlreadyExists_message, (Object)(" " + EFSUtilImpl.this.getLabel() + " ")), null));
                    }
                    if (exists && (this.mode & 1) != 0 && !this.forceCharset) {
                        try {
                            try {
                                InputStream raw = EFSUtilImpl.this.file.openInputStream(0, (IProgressMonitor)m.newChild(5));
                                FileUtil.FileInput fi = new FileUtil.FileInput(raw, null);
                                fi.close();
                                Charset defaultCharset = fi.getDefaultCharset();
                                if (defaultCharset != null) {
                                    this.charset = defaultCharset;
                                }
                            }
                            catch (IOException iOException) {
                                m.worked(5);
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            m.worked(5);
                            throw throwable;
                        }
                        m.worked(5);
                    } else {
                        m.worked(10);
                    }
                }
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter(EFSUtilImpl.this.file.openOutputStream(this.mode, (IProgressMonitor)m.newChild(5)), this.charset);){
                    writer.write(content);
                    m.worked(75);
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
    }
}

