/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.dcf.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslAstVisitor;
import org.eclipse.statet.dsl.core.source.ast.Dummy;
import org.eclipse.statet.dsl.core.source.ast.Scalar;
import org.eclipse.statet.internal.dsl.dcf.core.ProblemMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.ast.core.util.AbstractAstProblemReporter;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;

@NonNullByDefault
public class DcfAstProblemReporter
extends AbstractAstProblemReporter {
    private final Visitor visitor = new Visitor();

    public DcfAstProblemReporter(String modelTypeId) {
        super(modelTypeId);
    }

    public void run(DslAstNode node, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                node.acceptInDsl(this.visitor);
                this.flush();
            }
            catch (InvocationTargetException | OperationCanceledException throwable) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void handleCommonCodes(DslAstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0x700FF0) {
            case 4194784: {
                this.addProblem(2, code, this.getMessageBuilder().bind(ProblemMessages.Syntax_Gen_TokenUnknown_message, (Object)this.getMessageUtil().getShortQuoteText((AstNode)node, 0)), node.getStartOffset(), node.getEndOffset());
                return;
            }
        }
        super.handleCommonCodes((AstNode)node, code);
    }

    protected void handleEmbeddedNode(EmbeddingAstNode embeddingNode) {
    }

    private class Visitor
    extends DslAstVisitor {
        private Visitor() {
        }

        @Override
        public void visit(Scalar node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (DcfAstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x7F0FF0) {
                        case 4653840: {
                            DcfAstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Field_NameMissing_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4719104: {
                            DcfAstProblemReporter.this.addProblem(2, code, ProblemMessages.Syntax_Field_ValueUnexpected_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        default: {
                            DcfAstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            } else if ((node.getStatusCode() & 0x7000000) != 0 && node instanceof EmbeddingAstNode) {
                DcfAstProblemReporter.this.handleEmbeddedNode((EmbeddingAstNode)node);
            }
        }

        @Override
        public void visit(Dummy node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (DcfAstProblemReporter.this.requiredCheck(code)) {
                try {
                    DcfAstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

