/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.viewer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.ecommons.databinding.core.conversion.StringTrimConverter;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.debug.ui.config.InputArgumentsComposite;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigPresets;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithPresets;
import org.eclipse.statet.ecommons.io.win.DDE;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariables;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceVariableUtil;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableTextValidator;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.docmlet.base.ui.viewer.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public class DocViewerConfigMainTab
extends LaunchConfigTabWithPresets {
    private final ResourceVariableUtil resolvedSourceFileVariableUtil;
    private final Map<String, IStringVariable> resolvedSourceFileVariables = new HashMap<String, IStringVariable>();
    private final IObservableValue<String> programFileValue;
    private final IObservableValue<String> programArgumentsValue;
    private ResourceInputComposite programFileControl;
    private InputArgumentsComposite programArgumentsControl;
    private final ImList<DDETask> ddeTasks;

    public DocViewerConfigMainTab(LaunchConfigPresets presets) {
        Realm realm = this.getRealm();
        this.programFileValue = new WritableValue(realm, null, String.class);
        this.programArgumentsValue = new WritableValue(realm, null, String.class);
        this.setPresets(presets);
        this.resolvedSourceFileVariableUtil = new ResourceVariableUtil(){

            protected @Nullable IResource fetchResource() {
                IResource resource = super.fetchResource();
                return resource instanceof IFile ? resource : null;
            }
        };
        this.ddeTasks = DDE.isSupported() ? ImCollections.newList((Object[])new DDETask[]{new DDETask("org.eclipse.statet.docmlet.base/viewer/ViewOutput", realm, Messages.MainTab_DDE_ViewOutput_label, Messages.DDE_ViewOutput_label), new DDETask("org.eclipse.statet.docmlet.base/viewer/PreProduceOutput", realm, Messages.MainTab_DDE_PreProduceOutput_label, Messages.DDE_PreProduceOutput_label)}) : ImCollections.emptyList();
    }

    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/MainTab");
    }

    public String getName() {
        return Messages.MainTab_name;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.initVariables(this.resolvedSourceFileVariables);
    }

    protected void initVariables(Map<String, IStringVariable> variables) {
        VariableUtils.add(variables, (Collection)ResourceVariables.getSingleResourceVariables(), (IDynamicVariableResolver)new ResourceVariableResolver((ResourceVariableResolver.Context)this.resolvedSourceFileVariableUtil));
        VariableUtils.add(variables, (IStringVariable)VariableUtils.toStaticVariable((IStringVariable)DocProcessingConfig.SOURCE_FILE_PATH_VAR, (IStringVariable)variables.get("resource_path")));
    }

    public Map<String, IStringVariable> getSourceFileVariables() {
        return this.resolvedSourceFileVariables;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        this.addPresetsButton(mainComposite);
        Composite composite = this.createProgramGroup(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        LayoutUtils.addSmallFiller((Composite)mainComposite, (boolean)false);
        for (DDETask ddeTask : this.ddeTasks) {
            Composite composite2 = this.createDDEGroup(mainComposite, ddeTask);
            composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        LayoutUtils.addSmallFiller((Composite)mainComposite, (boolean)true);
        Label note = new Label(mainComposite, 64);
        note.setText(SharedMessages.Note_label + ": " + this.programArgumentsControl.getNoteText());
        note.setLayoutData((Object)new GridData(4, 1024, true, true));
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    protected Composite createProgramGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        group.setText(Messages.MainTab_Program_label + ":");
        ResourceInputComposite pathInput = new ResourceInputComposite((Composite)group, 0, 9, Messages.MainTab_ProgramPath_label);
        pathInput.getValidator().setResourceLabel(Messages.MainTab_ProgramPath_name);
        pathInput.getValidator().setVariableResolver(new VariableText2(this.getSourceFileVariables()));
        pathInput.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_INTERACTIVE_FILTERS, null);
        pathInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.programFileControl = pathInput;
        LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
        InputArgumentsComposite argsInput = new InputArgumentsComposite((Composite)group, Messages.MainTab_ProgramArgs_label + ":");
        argsInput.setVariableResolver(new VariableText2(this.getSourceFileVariables()));
        argsInput.setVariableFilter(VariableFilterUtils.DEFAULT_INTERACTIVE_FILTERS);
        argsInput.setLayoutData((Object)new GridData(4, 4, true, false));
        this.programArgumentsControl = argsInput;
        return group;
    }

    protected Composite createDDEGroup(Composite parent, DDETask task) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)4));
        group.setText(task.title + ":");
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.MainTab_DDECommand_label + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        InputArgumentsComposite input = new InputArgumentsComposite((Composite)group, 4, null);
        input.setVariableResolver(new VariableText2(this.getSourceFileVariables()));
        input.setVariableFilter(VariableFilterUtils.DEFAULT_INTERACTIVE_FILTERS);
        input.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        task.commandControl = input;
        label = new Label((Composite)group, 0);
        label.setText(Messages.MainTab_DDEApplication_label + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text((Composite)group, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)40);
        text.setLayoutData((Object)gd);
        task.applicationControl = text;
        label = new Label((Composite)group, 0);
        label.setText(Messages.MainTab_DDETopic_label + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        text = new Text((Composite)group, 2048);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)40);
        text.setLayoutData((Object)gd);
        task.topicControl = text;
        return group;
    }

    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue(this.programFileControl.getObservable(), this.programFileValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)this.programFileControl.getValidator())), null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.programArgumentsControl.getTextControl()), this.programArgumentsValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)new VariableTextValidator(this.programArgumentsControl.getVariableResolver(), Messages.ProgramArgs_error_Other_message))), null);
        for (DDETask ddeTask : this.ddeTasks) {
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)ddeTask.commandControl.getTextControl()), ddeTask.commandValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)new VariableTextValidator(ddeTask.commandControl.getVariableResolver(), NLS.bind((String)Messages.DDECommand_error_Other_message, (Object)ddeTask.label, (Object)"{0}")))), null);
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)ddeTask.applicationControl), ddeTask.applicationValue, new UpdateValueStrategy().setConverter(StringTrimConverter.INSTANCE).setAfterConvertValidator((IValidator)new UpdateableErrorValidator((IValidator)new VariableTextValidator(ddeTask.commandControl.getVariableResolver(), NLS.bind((String)Messages.DDEApplication_error_Other_message, (Object)ddeTask.label, (Object)"{0}")))), null);
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)ddeTask.topicControl), ddeTask.topicValue, new UpdateValueStrategy().setConverter(StringTrimConverter.INSTANCE).setAfterConvertValidator((IValidator)new UpdateableErrorValidator((IValidator)new VariableTextValidator(ddeTask.commandControl.getVariableResolver(), NLS.bind((String)Messages.DDETopic_error_Other_message, (Object)ddeTask.label, (Object)"{0}")))), null);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        if (((String)this.programFileValue.getValue()).isEmpty()) {
            this.setErrorMessage(null);
        }
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        this.programFileValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.docmlet.base/viewer/ProgramFile.path", ""));
        this.programArgumentsValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.docmlet.base/viewer/ProgramArguments.string", ""));
        for (DDETask ddeTask : this.ddeTasks) {
            ddeTask.commandValue.setValue((Object)this.readAttribute(configuration, ddeTask.attrQualifier + "/DDE.Command.message", ""));
            ddeTask.applicationValue.setValue((Object)this.readAttribute(configuration, ddeTask.attrQualifier + "/DDE.Application.name", ""));
            ddeTask.topicValue.setValue((Object)this.readAttribute(configuration, ddeTask.attrQualifier + "/DDE.Topic.name", ""));
        }
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        String path = (String)this.programFileValue.getValue();
        configuration.setAttribute("org.eclipse.statet.docmlet.base/viewer/ProgramFile.path", path);
        String s = (String)this.programArgumentsValue.getValue();
        configuration.setAttribute("org.eclipse.statet.docmlet.base/viewer/ProgramArguments.string", s);
        for (DDETask ddeTask : this.ddeTasks) {
            String message = (String)ddeTask.commandValue.getValue();
            if (message.isEmpty()) {
                message = null;
            }
            configuration.setAttribute(ddeTask.attrQualifier + "/DDE.Command.message", message);
            String name = (String)ddeTask.applicationValue.getValue();
            if (message == null && name.isEmpty()) {
                name = null;
            }
            configuration.setAttribute(ddeTask.attrQualifier + "/DDE.Application.name", name);
            name = (String)ddeTask.topicValue.getValue();
            if (message == null && name.isEmpty()) {
                name = null;
            }
            configuration.setAttribute(ddeTask.attrQualifier + "/DDE.Topic.name", name);
        }
    }

    private static class DDETask {
        final String attrQualifier;
        final String title;
        final String label;
        final IObservableValue<String> commandValue;
        final IObservableValue<String> applicationValue;
        final IObservableValue<String> topicValue;
        InputArgumentsComposite commandControl;
        Text applicationControl;
        Text topicControl;

        public DDETask(String attrQualifier, Realm realm, String title, String label) {
            this.attrQualifier = attrQualifier;
            this.title = title;
            this.label = label;
            this.commandValue = new WritableValue(realm, null, String.class);
            this.applicationValue = new WritableValue(realm, null, String.class);
            this.topicValue = new WritableValue(realm, null, String.class);
        }
    }
}

