/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.operations;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class CheckOutputOperation
extends DocProcessingOperation {
    public static final byte REFRESH_FILE = 1;
    public static final byte REFRESH_FILE_DIRECTORY = 2;
    public static final byte REFRESH_WORKING_DIRECTORY = 3;
    public static final String ID = "org.eclipse.statet.docmlet.base.docProcessing.CheckFileOperation";
    private IFile file;
    private byte refeshMode = 1;
    private int notExistsSeverity = 4;

    public CheckOutputOperation() {
    }

    public CheckOutputOperation(IFile file) {
        this.file = file;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getLabel() {
        return Messages.ProcessingOperation_CheckOutput_label;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setRefresh(byte mode) {
        this.refeshMode = mode;
    }

    public byte getRefresh() {
        return this.refeshMode;
    }

    public void setNotExistsSeverity(int severity) {
        this.notExistsSeverity = severity;
    }

    @Override
    public void init(DocProcessingToolConfig.StepConfig stepConfig, Map<String, String> settings, SubMonitor m) throws CoreException {
        super.init(stepConfig, settings, m);
        IFile file = (IFile)ObjectUtils.nullable((Object)this.file);
        if (file == null) {
            this.file = file = stepConfig.getOutputFile();
        }
    }

    @Override
    public int getTicks() {
        switch (this.refeshMode) {
            case 3: {
                return 20;
            }
            case 2: {
                return 15;
            }
        }
        return 10;
    }

    @Override
    public IStatus run(DocProcessingToolProcess toolProcess, SubMonitor m) throws CoreException {
        IContainer refreshResource;
        IFile file = this.file;
        if (ObjectUtils.isNull((Object)file)) {
            throw new IllegalStateException("not initialized");
        }
        m.beginTask(NLS.bind((String)Messages.ProcessingOperation_CheckOutput_task, (Object)this.getStepConfig().getLabel()), 13);
        boolean refreshFile = switch (this.refeshMode) {
            case 1 -> {
                refreshResource = null;
                yield true;
            }
            case 2 -> {
                refreshResource = file.getParent();
                yield false;
            }
            case 3 -> {
                refreshResource = this.getStepConfig().getToolConfig().getWorkingDirectory();
                yield refreshResource.getFullPath().isPrefixOf(file.getFullPath());
            }
            default -> {
                refreshResource = null;
                yield false;
            }
        };
        IResourceRuleFactory ruleFactory = file.getWorkspace().getRuleFactory();
        ISchedulingRule rule = null;
        if (refreshResource != null) {
            rule = ruleFactory.refreshRule((IResource)refreshResource);
        }
        if (refreshFile) {
            rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)ruleFactory.refreshRule((IResource)file));
        }
        ISchedulingRule schedulingRule = toolProcess.beginSchedulingRule(rule, (IProgressMonitor)m.newChild(1));
        try {
            IStatus iStatus;
            if (refreshResource != null) {
                refreshResource.refreshLocal(2, (IProgressMonitor)m.newChild(refreshFile ? 8 : 10));
            }
            if (refreshFile) {
                file.refreshLocal(0, (IProgressMonitor)m.newChild(refreshResource != null ? 2 : 10));
            }
            if (!file.exists()) {
                iStatus = new Status(this.notExistsSeverity, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingOperation_CheckOutput_error_FileNotExists_message, (Object)file.getName(), (Object)this.getStepConfig().getLabel()));
                return iStatus;
            }
            iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            toolProcess.endSchedulingRule(schedulingRule);
        }
    }
}

